/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DevicesDevicesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDevice;
import com.azure.resourcemanager.authorization.fluent.models.DevicesDeviceExpand;
import com.azure.resourcemanager.authorization.fluent.models.DevicesDeviceOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DevicesDeviceSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DevicesDevicesClientImpl
implements DevicesDevicesClient {
    private final ClientLogger logger = new ClientLogger(DevicesDevicesClientImpl.class);
    private final DevicesDevicesService service;
    private final MicrosoftGraphClientImpl client;

    DevicesDevicesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DevicesDevicesService)RestProxy.create(DevicesDevicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDeviceInner>> listDeviceSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesDeviceOrderby> orderby, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDevice(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDevice)res.getValue()).value(), ((CollectionOfDevice)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDeviceInner>> listDeviceSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesDeviceOrderby> orderby, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDevice(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDevice)res.getValue()).value(), ((CollectionOfDevice)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDeviceInner> listDeviceAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesDeviceOrderby> orderby, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand) {
        return new PagedFlux(() -> this.listDeviceSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDeviceInner> listDeviceAsync() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDeviceSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDeviceInner> listDeviceAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesDeviceOrderby> orderby, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand, Context context) {
        return new PagedFlux(() -> this.listDeviceSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDeviceInner> listDevice() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DevicesDeviceOrderby> orderby = null;
        List<DevicesDeviceSelect> select = null;
        List<DevicesDeviceExpand> expand = null;
        return new PagedIterable(this.listDeviceAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDeviceInner> listDevice(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<DevicesDeviceOrderby> orderby, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand, Context context) {
        return new PagedIterable(this.listDeviceAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDeviceInner>> createDeviceWithResponseAsync(MicrosoftGraphDeviceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDevice(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDeviceInner>> createDeviceWithResponseAsync(MicrosoftGraphDeviceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDevice(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDeviceInner> createDeviceAsync(MicrosoftGraphDeviceInner body) {
        return this.createDeviceWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDeviceInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDeviceInner createDevice(MicrosoftGraphDeviceInner body) {
        return (MicrosoftGraphDeviceInner)this.createDeviceAsync(body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDeviceInner> createDeviceWithResponse(MicrosoftGraphDeviceInner body, Context context) {
        return (Response)this.createDeviceWithResponseAsync(body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDeviceInner>> getDeviceWithResponseAsync(String deviceId, String consistencyLevel, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getDevice(this.client.getEndpoint(), deviceId, consistencyLevel, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDeviceInner>> getDeviceWithResponseAsync(String deviceId, String consistencyLevel, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getDevice(this.client.getEndpoint(), deviceId, consistencyLevel, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDeviceInner> getDeviceAsync(String deviceId, String consistencyLevel, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand) {
        return this.getDeviceWithResponseAsync(deviceId, consistencyLevel, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDeviceInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDeviceInner> getDeviceAsync(String deviceId) {
        String consistencyLevel = null;
        List<DevicesDeviceSelect> select = null;
        List<DevicesDeviceExpand> expand = null;
        return this.getDeviceWithResponseAsync(deviceId, consistencyLevel, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDeviceInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDeviceInner getDevice(String deviceId) {
        String consistencyLevel = null;
        List<DevicesDeviceSelect> select = null;
        List<DevicesDeviceExpand> expand = null;
        return (MicrosoftGraphDeviceInner)this.getDeviceAsync(deviceId, consistencyLevel, select, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDeviceInner> getDeviceWithResponse(String deviceId, String consistencyLevel, List<DevicesDeviceSelect> select, List<DevicesDeviceExpand> expand, Context context) {
        return (Response)this.getDeviceWithResponseAsync(deviceId, consistencyLevel, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateDeviceWithResponseAsync(String deviceId, MicrosoftGraphDeviceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDevice(this.client.getEndpoint(), deviceId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateDeviceWithResponseAsync(String deviceId, MicrosoftGraphDeviceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDevice(this.client.getEndpoint(), deviceId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateDeviceAsync(String deviceId, MicrosoftGraphDeviceInner body) {
        return this.updateDeviceWithResponseAsync(deviceId, body).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateDevice(String deviceId, MicrosoftGraphDeviceInner body) {
        this.updateDeviceAsync(deviceId, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateDeviceWithResponse(String deviceId, MicrosoftGraphDeviceInner body, Context context) {
        return (Response)this.updateDeviceWithResponseAsync(deviceId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeviceWithResponseAsync(String deviceId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDevice(this.client.getEndpoint(), deviceId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDeviceWithResponseAsync(String deviceId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (deviceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deviceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDevice(this.client.getEndpoint(), deviceId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDeviceAsync(String deviceId, String ifMatch) {
        return this.deleteDeviceWithResponseAsync(deviceId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDeviceAsync(String deviceId) {
        String ifMatch = null;
        return this.deleteDeviceWithResponseAsync(deviceId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDevice(String deviceId) {
        String ifMatch = null;
        this.deleteDeviceAsync(deviceId, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeviceWithResponse(String deviceId, String ifMatch, Context context) {
        return (Response)this.deleteDeviceWithResponseAsync(deviceId, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDeviceInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDevice)res.getValue()).value(), ((CollectionOfDevice)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDeviceInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDevice)res.getValue()).value(), ((CollectionOfDevice)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DevicesDevicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDevice>> listDevice(@HostParam(value="$host") String var1, @HeaderParam(value="ConsistencyLevel") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/devices")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDeviceInner>> createDevice(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphDeviceInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/devices/{device-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDeviceInner>> getDevice(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @HeaderParam(value="ConsistencyLevel") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/devices/{device-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateDevice(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDeviceInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/devices/{device-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteDevice(@HostParam(value="$host") String var1, @PathParam(value="device-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDevice>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

