/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.GroupsGroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGroupInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryGroupImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroups;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class ActiveDirectoryGroupsImpl
extends CreatableWrappersImpl<ActiveDirectoryGroup, ActiveDirectoryGroupImpl, MicrosoftGraphGroupInner>
implements ActiveDirectoryGroups {
    private final AuthorizationManager manager;

    public ActiveDirectoryGroupsImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    public PagedIterable<ActiveDirectoryGroup> list() {
        return new PagedIterable(this.listAsync());
    }

    protected ActiveDirectoryGroupImpl wrapModel(MicrosoftGraphGroupInner groupInner) {
        if (groupInner == null) {
            return null;
        }
        return new ActiveDirectoryGroupImpl(groupInner, this.manager());
    }

    public ActiveDirectoryGroupImpl getById(String objectId) {
        return (ActiveDirectoryGroupImpl)this.getByIdAsync(objectId).block();
    }

    public Mono<ActiveDirectoryGroup> getByIdAsync(String id) {
        return this.inner().getGroupAsync(id).map(groupInner -> new ActiveDirectoryGroupImpl((MicrosoftGraphGroupInner)groupInner, this.manager()));
    }

    public PagedFlux<ActiveDirectoryGroup> listAsync() {
        return this.wrapPageAsync(this.inner().listGroupAsync());
    }

    public Mono<ActiveDirectoryGroup> getByNameAsync(String name) {
        return this.listByFilterAsync(String.format("displayName eq '%s'", name)).singleOrEmpty();
    }

    public ActiveDirectoryGroup getByName(String name) {
        return (ActiveDirectoryGroup)this.getByNameAsync(name).block();
    }

    public ActiveDirectoryGroupImpl define(String name) {
        return this.wrapModel(name);
    }

    protected ActiveDirectoryGroupImpl wrapModel(String name) {
        return this.wrapModel(new MicrosoftGraphGroupInner().withDisplayName(name));
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteGroupAsync(id);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public GroupsGroupsClient inner() {
        return this.manager().serviceClient().getGroupsGroups();
    }

    public PagedIterable<ActiveDirectoryGroup> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ActiveDirectoryGroup> listByFilterAsync(String filter) {
        return PagedConverter.mapPage(this.inner().listGroupAsync(null, null, null, null, filter, null, null, null, null), this::wrapModel);
    }
}

