/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphExtensionPropertyInner
extends MicrosoftGraphDirectoryObjectInner {
    private String appDisplayName;
    private String dataType;
    private Boolean isSyncedFromOnPremises;
    private String name;
    private List<String> targetObjects;
    private Map<String, Object> additionalProperties;

    public String appDisplayName() {
        return this.appDisplayName;
    }

    public MicrosoftGraphExtensionPropertyInner withAppDisplayName(String appDisplayName) {
        this.appDisplayName = appDisplayName;
        return this;
    }

    public String dataType() {
        return this.dataType;
    }

    public MicrosoftGraphExtensionPropertyInner withDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public Boolean isSyncedFromOnPremises() {
        return this.isSyncedFromOnPremises;
    }

    public MicrosoftGraphExtensionPropertyInner withIsSyncedFromOnPremises(Boolean isSyncedFromOnPremises) {
        this.isSyncedFromOnPremises = isSyncedFromOnPremises;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphExtensionPropertyInner withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> targetObjects() {
        return this.targetObjects;
    }

    public MicrosoftGraphExtensionPropertyInner withTargetObjects(List<String> targetObjects) {
        this.targetObjects = targetObjects;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphExtensionPropertyInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphExtensionPropertyInner withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphExtensionPropertyInner withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("appDisplayName", this.appDisplayName);
        jsonWriter.writeStringField("dataType", this.dataType);
        jsonWriter.writeBooleanField("isSyncedFromOnPremises", this.isSyncedFromOnPremises);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("targetObjects", this.targetObjects, (writer, element) -> writer.writeString(element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphExtensionPropertyInner fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphExtensionPropertyInner)jsonReader.readObject(reader -> {
            MicrosoftGraphExtensionPropertyInner deserializedMicrosoftGraphExtensionPropertyInner = new MicrosoftGraphExtensionPropertyInner();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphExtensionPropertyInner.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphExtensionPropertyInner.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("appDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphExtensionPropertyInner.appDisplayName = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    deserializedMicrosoftGraphExtensionPropertyInner.dataType = reader.getString();
                    continue;
                }
                if ("isSyncedFromOnPremises".equals(fieldName)) {
                    deserializedMicrosoftGraphExtensionPropertyInner.isSyncedFromOnPremises = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphExtensionPropertyInner.name = reader.getString();
                    continue;
                }
                if ("targetObjects".equals(fieldName)) {
                    List targetObjects;
                    deserializedMicrosoftGraphExtensionPropertyInner.targetObjects = targetObjects = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphExtensionPropertyInner.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphExtensionPropertyInner;
        });
    }
}

