/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.PolicyAssignmentPropertiesPolicy;
import com.azure.resourcemanager.authorization.models.PolicyAssignmentPropertiesRoleDefinition;
import com.azure.resourcemanager.authorization.models.PolicyAssignmentPropertiesScope;
import java.io.IOException;

public final class PolicyAssignmentProperties
implements JsonSerializable<PolicyAssignmentProperties> {
    private PolicyAssignmentPropertiesScope scope;
    private PolicyAssignmentPropertiesRoleDefinition roleDefinition;
    private PolicyAssignmentPropertiesPolicy policy;

    public PolicyAssignmentPropertiesScope scope() {
        return this.scope;
    }

    public PolicyAssignmentProperties withScope(PolicyAssignmentPropertiesScope scope) {
        this.scope = scope;
        return this;
    }

    public PolicyAssignmentPropertiesRoleDefinition roleDefinition() {
        return this.roleDefinition;
    }

    public PolicyAssignmentProperties withRoleDefinition(PolicyAssignmentPropertiesRoleDefinition roleDefinition) {
        this.roleDefinition = roleDefinition;
        return this;
    }

    public PolicyAssignmentPropertiesPolicy policy() {
        return this.policy;
    }

    public PolicyAssignmentProperties withPolicy(PolicyAssignmentPropertiesPolicy policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.scope() != null) {
            this.scope().validate();
        }
        if (this.roleDefinition() != null) {
            this.roleDefinition().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("scope", (JsonSerializable)this.scope);
        jsonWriter.writeJsonField("roleDefinition", (JsonSerializable)this.roleDefinition);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentProperties)jsonReader.readObject(reader -> {
            PolicyAssignmentProperties deserializedPolicyAssignmentProperties = new PolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.scope = PolicyAssignmentPropertiesScope.fromJson(reader);
                    continue;
                }
                if ("roleDefinition".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.roleDefinition = PolicyAssignmentPropertiesRoleDefinition.fromJson(reader);
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.policy = PolicyAssignmentPropertiesPolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentProperties;
        });
    }
}

