/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.RequestType;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesScheduleInfo;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestPropertiesTicketInfo;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RoleEligibilityScheduleRequestProperties
implements JsonSerializable<RoleEligibilityScheduleRequestProperties> {
    private String scope;
    private String roleDefinitionId;
    private String principalId;
    private PrincipalType principalType;
    private RequestType requestType;
    private Status status;
    private String approvalId;
    private RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo;
    private String targetRoleEligibilityScheduleId;
    private String targetRoleEligibilityScheduleInstanceId;
    private String justification;
    private RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo;
    private String condition;
    private String conditionVersion;
    private OffsetDateTime createdOn;
    private String requestorId;
    private ExpandedProperties expandedProperties;
    private static final ClientLogger LOGGER = new ClientLogger(RoleEligibilityScheduleRequestProperties.class);

    public String scope() {
        return this.scope;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public RoleEligibilityScheduleRequestProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleEligibilityScheduleRequestProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    public RoleEligibilityScheduleRequestProperties withRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public String approvalId() {
        return this.approvalId;
    }

    public RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo() {
        return this.scheduleInfo;
    }

    public RoleEligibilityScheduleRequestProperties withScheduleInfo(RoleEligibilityScheduleRequestPropertiesScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    public String targetRoleEligibilityScheduleId() {
        return this.targetRoleEligibilityScheduleId;
    }

    public RoleEligibilityScheduleRequestProperties withTargetRoleEligibilityScheduleId(String targetRoleEligibilityScheduleId) {
        this.targetRoleEligibilityScheduleId = targetRoleEligibilityScheduleId;
        return this;
    }

    public String targetRoleEligibilityScheduleInstanceId() {
        return this.targetRoleEligibilityScheduleInstanceId;
    }

    public RoleEligibilityScheduleRequestProperties withTargetRoleEligibilityScheduleInstanceId(String targetRoleEligibilityScheduleInstanceId) {
        this.targetRoleEligibilityScheduleInstanceId = targetRoleEligibilityScheduleInstanceId;
        return this;
    }

    public String justification() {
        return this.justification;
    }

    public RoleEligibilityScheduleRequestProperties withJustification(String justification) {
        this.justification = justification;
        return this;
    }

    public RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo() {
        return this.ticketInfo;
    }

    public RoleEligibilityScheduleRequestProperties withTicketInfo(RoleEligibilityScheduleRequestPropertiesTicketInfo ticketInfo) {
        this.ticketInfo = ticketInfo;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RoleEligibilityScheduleRequestProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public RoleEligibilityScheduleRequestProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public String requestorId() {
        return this.requestorId;
    }

    public ExpandedProperties expandedProperties() {
        return this.expandedProperties;
    }

    public void validate() {
        if (this.roleDefinitionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roleDefinitionId in model RoleEligibilityScheduleRequestProperties"));
        }
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model RoleEligibilityScheduleRequestProperties"));
        }
        if (this.requestType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requestType in model RoleEligibilityScheduleRequestProperties"));
        }
        if (this.scheduleInfo() != null) {
            this.scheduleInfo().validate();
        }
        if (this.ticketInfo() != null) {
            this.ticketInfo().validate();
        }
        if (this.expandedProperties() != null) {
            this.expandedProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("requestType", this.requestType == null ? null : this.requestType.toString());
        jsonWriter.writeJsonField("scheduleInfo", (JsonSerializable)this.scheduleInfo);
        jsonWriter.writeStringField("targetRoleEligibilityScheduleId", this.targetRoleEligibilityScheduleId);
        jsonWriter.writeStringField("targetRoleEligibilityScheduleInstanceId", this.targetRoleEligibilityScheduleInstanceId);
        jsonWriter.writeStringField("justification", this.justification);
        jsonWriter.writeJsonField("ticketInfo", (JsonSerializable)this.ticketInfo);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        return jsonWriter.writeEndObject();
    }

    public static RoleEligibilityScheduleRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleEligibilityScheduleRequestProperties)jsonReader.readObject(reader -> {
            RoleEligibilityScheduleRequestProperties deserializedRoleEligibilityScheduleRequestProperties = new RoleEligibilityScheduleRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.roleDefinitionId = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.principalId = reader.getString();
                    continue;
                }
                if ("requestType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.requestType = RequestType.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.scope = reader.getString();
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("approvalId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.approvalId = reader.getString();
                    continue;
                }
                if ("scheduleInfo".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.scheduleInfo = RoleEligibilityScheduleRequestPropertiesScheduleInfo.fromJson(reader);
                    continue;
                }
                if ("targetRoleEligibilityScheduleId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.targetRoleEligibilityScheduleId = reader.getString();
                    continue;
                }
                if ("targetRoleEligibilityScheduleInstanceId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.targetRoleEligibilityScheduleInstanceId = reader.getString();
                    continue;
                }
                if ("justification".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.justification = reader.getString();
                    continue;
                }
                if ("ticketInfo".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.ticketInfo = RoleEligibilityScheduleRequestPropertiesTicketInfo.fromJson(reader);
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.condition = reader.getString();
                    continue;
                }
                if ("conditionVersion".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.conditionVersion = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("requestorId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.requestorId = reader.getString();
                    continue;
                }
                if ("expandedProperties".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleRequestProperties.expandedProperties = ExpandedProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleEligibilityScheduleRequestProperties;
        });
    }
}

