/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleChangeRequest;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleChangeRequestActor;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleChangeState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTimeOffRequest
extends MicrosoftGraphScheduleChangeRequest {
    private OffsetDateTime endDateTime;
    private OffsetDateTime startDateTime;
    private String timeOffReasonId;
    private Map<String, Object> additionalProperties;

    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    public MicrosoftGraphTimeOffRequest withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public MicrosoftGraphTimeOffRequest withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public String timeOffReasonId() {
        return this.timeOffReasonId;
    }

    public MicrosoftGraphTimeOffRequest withTimeOffReasonId(String timeOffReasonId) {
        this.timeOffReasonId = timeOffReasonId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withAssignedTo(MicrosoftGraphScheduleChangeRequestActor assignedTo) {
        super.withAssignedTo(assignedTo);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withManagerActionDateTime(OffsetDateTime managerActionDateTime) {
        super.withManagerActionDateTime(managerActionDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withManagerActionMessage(String managerActionMessage) {
        super.withManagerActionMessage(managerActionMessage);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withManagerUserId(String managerUserId) {
        super.withManagerUserId(managerUserId);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withSenderDateTime(OffsetDateTime senderDateTime) {
        super.withSenderDateTime(senderDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withSenderMessage(String senderMessage) {
        super.withSenderMessage(senderMessage);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withSenderUserId(String senderUserId) {
        super.withSenderUserId(senderUserId);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withState(MicrosoftGraphScheduleChangeState state) {
        super.withState(state);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOffRequest withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("assignedTo", this.assignedTo() == null ? null : this.assignedTo().toString());
        jsonWriter.writeStringField("managerActionDateTime", this.managerActionDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.managerActionDateTime()));
        jsonWriter.writeStringField("managerActionMessage", this.managerActionMessage());
        jsonWriter.writeStringField("managerUserId", this.managerUserId());
        jsonWriter.writeStringField("senderDateTime", this.senderDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.senderDateTime()));
        jsonWriter.writeStringField("senderMessage", this.senderMessage());
        jsonWriter.writeStringField("senderUserId", this.senderUserId());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("endDateTime", this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("timeOffReasonId", this.timeOffReasonId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTimeOffRequest fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTimeOffRequest)jsonReader.readObject(reader -> {
            MicrosoftGraphTimeOffRequest deserializedMicrosoftGraphTimeOffRequest = new MicrosoftGraphTimeOffRequest();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("assignedTo".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withAssignedTo(MicrosoftGraphScheduleChangeRequestActor.fromString(reader.getString()));
                    continue;
                }
                if ("managerActionDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withManagerActionDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("managerActionMessage".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withManagerActionMessage(reader.getString());
                    continue;
                }
                if ("managerUserId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withManagerUserId(reader.getString());
                    continue;
                }
                if ("senderDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withSenderDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("senderMessage".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withSenderMessage(reader.getString());
                    continue;
                }
                if ("senderUserId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withSenderUserId(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.withState(MicrosoftGraphScheduleChangeState.fromString(reader.getString()));
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("timeOffReasonId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOffRequest.timeOffReasonId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTimeOffRequest.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTimeOffRequest;
        });
    }
}

