/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTeamsAppDefinition;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTeamsAppDistributionMethod;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphTeamsApp
extends MicrosoftGraphEntity {
    private String displayName;
    private MicrosoftGraphTeamsAppDistributionMethod distributionMethod;
    private String externalId;
    private List<MicrosoftGraphTeamsAppDefinition> appDefinitions;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphTeamsApp withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MicrosoftGraphTeamsAppDistributionMethod distributionMethod() {
        return this.distributionMethod;
    }

    public MicrosoftGraphTeamsApp withDistributionMethod(MicrosoftGraphTeamsAppDistributionMethod distributionMethod) {
        this.distributionMethod = distributionMethod;
        return this;
    }

    public String externalId() {
        return this.externalId;
    }

    public MicrosoftGraphTeamsApp withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public List<MicrosoftGraphTeamsAppDefinition> appDefinitions() {
        return this.appDefinitions;
    }

    public MicrosoftGraphTeamsApp withAppDefinitions(List<MicrosoftGraphTeamsAppDefinition> appDefinitions) {
        this.appDefinitions = appDefinitions;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTeamsApp withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTeamsApp withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.appDefinitions() != null) {
            this.appDefinitions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("distributionMethod", this.distributionMethod == null ? null : this.distributionMethod.toString());
        jsonWriter.writeStringField("externalId", this.externalId);
        jsonWriter.writeArrayField("appDefinitions", this.appDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTeamsApp fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTeamsApp)jsonReader.readObject(reader -> {
            MicrosoftGraphTeamsApp deserializedMicrosoftGraphTeamsApp = new MicrosoftGraphTeamsApp();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.withId(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.displayName = reader.getString();
                    continue;
                }
                if ("distributionMethod".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.distributionMethod = MicrosoftGraphTeamsAppDistributionMethod.fromString(reader.getString());
                    continue;
                }
                if ("externalId".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.externalId = reader.getString();
                    continue;
                }
                if ("appDefinitions".equals(fieldName)) {
                    List appDefinitions;
                    deserializedMicrosoftGraphTeamsApp.appDefinitions = appDefinitions = reader.readArray(reader1 -> MicrosoftGraphTeamsAppDefinition.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTeamsApp.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTeamsApp;
        });
    }
}

