/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphGiphyRatingType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTeamFunSettings
implements JsonSerializable<MicrosoftGraphTeamFunSettings> {
    private Boolean allowCustomMemes;
    private Boolean allowGiphy;
    private Boolean allowStickersAndMemes;
    private MicrosoftGraphGiphyRatingType giphyContentRating;
    private Map<String, Object> additionalProperties;

    public Boolean allowCustomMemes() {
        return this.allowCustomMemes;
    }

    public MicrosoftGraphTeamFunSettings withAllowCustomMemes(Boolean allowCustomMemes) {
        this.allowCustomMemes = allowCustomMemes;
        return this;
    }

    public Boolean allowGiphy() {
        return this.allowGiphy;
    }

    public MicrosoftGraphTeamFunSettings withAllowGiphy(Boolean allowGiphy) {
        this.allowGiphy = allowGiphy;
        return this;
    }

    public Boolean allowStickersAndMemes() {
        return this.allowStickersAndMemes;
    }

    public MicrosoftGraphTeamFunSettings withAllowStickersAndMemes(Boolean allowStickersAndMemes) {
        this.allowStickersAndMemes = allowStickersAndMemes;
        return this;
    }

    public MicrosoftGraphGiphyRatingType giphyContentRating() {
        return this.giphyContentRating;
    }

    public MicrosoftGraphTeamFunSettings withGiphyContentRating(MicrosoftGraphGiphyRatingType giphyContentRating) {
        this.giphyContentRating = giphyContentRating;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphTeamFunSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowCustomMemes", this.allowCustomMemes);
        jsonWriter.writeBooleanField("allowGiphy", this.allowGiphy);
        jsonWriter.writeBooleanField("allowStickersAndMemes", this.allowStickersAndMemes);
        jsonWriter.writeStringField("giphyContentRating", this.giphyContentRating == null ? null : this.giphyContentRating.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTeamFunSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTeamFunSettings)jsonReader.readObject(reader -> {
            MicrosoftGraphTeamFunSettings deserializedMicrosoftGraphTeamFunSettings = new MicrosoftGraphTeamFunSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("allowCustomMemes".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.allowCustomMemes = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowGiphy".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.allowGiphy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowStickersAndMemes".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.allowStickersAndMemes = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("giphyContentRating".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamFunSettings.giphyContentRating = MicrosoftGraphGiphyRatingType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTeamFunSettings.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTeamFunSettings;
        });
    }
}

