/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteSourceService;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphRecentNotebookLinks;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphRecentNotebook
implements JsonSerializable<MicrosoftGraphRecentNotebook> {
    private String displayName;
    private OffsetDateTime lastAccessedTime;
    private MicrosoftGraphRecentNotebookLinks links;
    private MicrosoftGraphOnenoteSourceService sourceService;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphRecentNotebook withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public MicrosoftGraphRecentNotebook withLastAccessedTime(OffsetDateTime lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    public MicrosoftGraphRecentNotebookLinks links() {
        return this.links;
    }

    public MicrosoftGraphRecentNotebook withLinks(MicrosoftGraphRecentNotebookLinks links) {
        this.links = links;
        return this;
    }

    public MicrosoftGraphOnenoteSourceService sourceService() {
        return this.sourceService;
    }

    public MicrosoftGraphRecentNotebook withSourceService(MicrosoftGraphOnenoteSourceService sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphRecentNotebook withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.links() != null) {
            this.links().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("lastAccessedTime", this.lastAccessedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastAccessedTime));
        jsonWriter.writeJsonField("links", (JsonSerializable)this.links);
        jsonWriter.writeStringField("sourceService", this.sourceService == null ? null : this.sourceService.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphRecentNotebook fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphRecentNotebook)jsonReader.readObject(reader -> {
            MicrosoftGraphRecentNotebook deserializedMicrosoftGraphRecentNotebook = new MicrosoftGraphRecentNotebook();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.displayName = reader.getString();
                    continue;
                }
                if ("lastAccessedTime".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.lastAccessedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.links = MicrosoftGraphRecentNotebookLinks.fromJson(reader);
                    continue;
                }
                if ("sourceService".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.sourceService = MicrosoftGraphOnenoteSourceService.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphRecentNotebook.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphRecentNotebook;
        });
    }
}

