/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPlannerTask;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphPlannerBucket
extends MicrosoftGraphEntity {
    private String name;
    private String orderHint;
    private String planId;
    private List<MicrosoftGraphPlannerTask> tasks;
    private Map<String, Object> additionalProperties;

    public String name() {
        return this.name;
    }

    public MicrosoftGraphPlannerBucket withName(String name) {
        this.name = name;
        return this;
    }

    public String orderHint() {
        return this.orderHint;
    }

    public MicrosoftGraphPlannerBucket withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    public String planId() {
        return this.planId;
    }

    public MicrosoftGraphPlannerBucket withPlanId(String planId) {
        this.planId = planId;
        return this;
    }

    public List<MicrosoftGraphPlannerTask> tasks() {
        return this.tasks;
    }

    public MicrosoftGraphPlannerBucket withTasks(List<MicrosoftGraphPlannerTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphPlannerBucket withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphPlannerBucket withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.tasks() != null) {
            this.tasks().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("orderHint", this.orderHint);
        jsonWriter.writeStringField("planId", this.planId);
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphPlannerBucket fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphPlannerBucket)jsonReader.readObject(reader -> {
            MicrosoftGraphPlannerBucket deserializedMicrosoftGraphPlannerBucket = new MicrosoftGraphPlannerBucket();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerBucket.withId(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerBucket.name = reader.getString();
                    continue;
                }
                if ("orderHint".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerBucket.orderHint = reader.getString();
                    continue;
                }
                if ("planId".equals(fieldName)) {
                    deserializedMicrosoftGraphPlannerBucket.planId = reader.getString();
                    continue;
                }
                if ("tasks".equals(fieldName)) {
                    List tasks;
                    deserializedMicrosoftGraphPlannerBucket.tasks = tasks = reader.readArray(reader1 -> MicrosoftGraphPlannerTask.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphPlannerBucket.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphPlannerBucket;
        });
    }
}

