/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEmailAddress;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtension;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMultiValueLegacyExtendedProperty;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPhysicalAddress;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphProfilePhoto;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSingleValueLegacyExtendedProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphContact
extends MicrosoftGraphOutlookItem {
    private String assistantName;
    private OffsetDateTime birthday;
    private MicrosoftGraphPhysicalAddress businessAddress;
    private String businessHomePage;
    private List<String> businessPhones;
    private List<String> children;
    private String companyName;
    private String department;
    private String displayName;
    private List<MicrosoftGraphEmailAddress> emailAddresses;
    private String fileAs;
    private String generation;
    private String givenName;
    private MicrosoftGraphPhysicalAddress homeAddress;
    private List<String> homePhones;
    private List<String> imAddresses;
    private String initials;
    private String jobTitle;
    private String manager;
    private String middleName;
    private String mobilePhone;
    private String nickName;
    private String officeLocation;
    private MicrosoftGraphPhysicalAddress otherAddress;
    private String parentFolderId;
    private String personalNotes;
    private String profession;
    private String spouseName;
    private String surname;
    private String title;
    private String yomiCompanyName;
    private String yomiGivenName;
    private String yomiSurname;
    private List<MicrosoftGraphExtension> extensions;
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;
    private MicrosoftGraphProfilePhoto photo;
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;
    private Map<String, Object> additionalProperties;

    public String assistantName() {
        return this.assistantName;
    }

    public MicrosoftGraphContact withAssistantName(String assistantName) {
        this.assistantName = assistantName;
        return this;
    }

    public OffsetDateTime birthday() {
        return this.birthday;
    }

    public MicrosoftGraphContact withBirthday(OffsetDateTime birthday) {
        this.birthday = birthday;
        return this;
    }

    public MicrosoftGraphPhysicalAddress businessAddress() {
        return this.businessAddress;
    }

    public MicrosoftGraphContact withBusinessAddress(MicrosoftGraphPhysicalAddress businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public String businessHomePage() {
        return this.businessHomePage;
    }

    public MicrosoftGraphContact withBusinessHomePage(String businessHomePage) {
        this.businessHomePage = businessHomePage;
        return this;
    }

    public List<String> businessPhones() {
        return this.businessPhones;
    }

    public MicrosoftGraphContact withBusinessPhones(List<String> businessPhones) {
        this.businessPhones = businessPhones;
        return this;
    }

    public List<String> children() {
        return this.children;
    }

    public MicrosoftGraphContact withChildren(List<String> children) {
        this.children = children;
        return this;
    }

    public String companyName() {
        return this.companyName;
    }

    public MicrosoftGraphContact withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public String department() {
        return this.department;
    }

    public MicrosoftGraphContact withDepartment(String department) {
        this.department = department;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphContact withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public List<MicrosoftGraphEmailAddress> emailAddresses() {
        return this.emailAddresses;
    }

    public MicrosoftGraphContact withEmailAddresses(List<MicrosoftGraphEmailAddress> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public String fileAs() {
        return this.fileAs;
    }

    public MicrosoftGraphContact withFileAs(String fileAs) {
        this.fileAs = fileAs;
        return this;
    }

    public String generation() {
        return this.generation;
    }

    public MicrosoftGraphContact withGeneration(String generation) {
        this.generation = generation;
        return this;
    }

    public String givenName() {
        return this.givenName;
    }

    public MicrosoftGraphContact withGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    public MicrosoftGraphPhysicalAddress homeAddress() {
        return this.homeAddress;
    }

    public MicrosoftGraphContact withHomeAddress(MicrosoftGraphPhysicalAddress homeAddress) {
        this.homeAddress = homeAddress;
        return this;
    }

    public List<String> homePhones() {
        return this.homePhones;
    }

    public MicrosoftGraphContact withHomePhones(List<String> homePhones) {
        this.homePhones = homePhones;
        return this;
    }

    public List<String> imAddresses() {
        return this.imAddresses;
    }

    public MicrosoftGraphContact withImAddresses(List<String> imAddresses) {
        this.imAddresses = imAddresses;
        return this;
    }

    public String initials() {
        return this.initials;
    }

    public MicrosoftGraphContact withInitials(String initials) {
        this.initials = initials;
        return this;
    }

    public String jobTitle() {
        return this.jobTitle;
    }

    public MicrosoftGraphContact withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    public String manager() {
        return this.manager;
    }

    public MicrosoftGraphContact withManager(String manager) {
        this.manager = manager;
        return this;
    }

    public String middleName() {
        return this.middleName;
    }

    public MicrosoftGraphContact withMiddleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public String mobilePhone() {
        return this.mobilePhone;
    }

    public MicrosoftGraphContact withMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public String nickName() {
        return this.nickName;
    }

    public MicrosoftGraphContact withNickName(String nickName) {
        this.nickName = nickName;
        return this;
    }

    public String officeLocation() {
        return this.officeLocation;
    }

    public MicrosoftGraphContact withOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
        return this;
    }

    public MicrosoftGraphPhysicalAddress otherAddress() {
        return this.otherAddress;
    }

    public MicrosoftGraphContact withOtherAddress(MicrosoftGraphPhysicalAddress otherAddress) {
        this.otherAddress = otherAddress;
        return this;
    }

    public String parentFolderId() {
        return this.parentFolderId;
    }

    public MicrosoftGraphContact withParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
        return this;
    }

    public String personalNotes() {
        return this.personalNotes;
    }

    public MicrosoftGraphContact withPersonalNotes(String personalNotes) {
        this.personalNotes = personalNotes;
        return this;
    }

    public String profession() {
        return this.profession;
    }

    public MicrosoftGraphContact withProfession(String profession) {
        this.profession = profession;
        return this;
    }

    public String spouseName() {
        return this.spouseName;
    }

    public MicrosoftGraphContact withSpouseName(String spouseName) {
        this.spouseName = spouseName;
        return this;
    }

    public String surname() {
        return this.surname;
    }

    public MicrosoftGraphContact withSurname(String surname) {
        this.surname = surname;
        return this;
    }

    public String title() {
        return this.title;
    }

    public MicrosoftGraphContact withTitle(String title) {
        this.title = title;
        return this;
    }

    public String yomiCompanyName() {
        return this.yomiCompanyName;
    }

    public MicrosoftGraphContact withYomiCompanyName(String yomiCompanyName) {
        this.yomiCompanyName = yomiCompanyName;
        return this;
    }

    public String yomiGivenName() {
        return this.yomiGivenName;
    }

    public MicrosoftGraphContact withYomiGivenName(String yomiGivenName) {
        this.yomiGivenName = yomiGivenName;
        return this;
    }

    public String yomiSurname() {
        return this.yomiSurname;
    }

    public MicrosoftGraphContact withYomiSurname(String yomiSurname) {
        this.yomiSurname = yomiSurname;
        return this;
    }

    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    public MicrosoftGraphContact withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    public MicrosoftGraphContact withMultiValueExtendedProperties(List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    public MicrosoftGraphProfilePhoto photo() {
        return this.photo;
    }

    public MicrosoftGraphContact withPhoto(MicrosoftGraphProfilePhoto photo) {
        this.photo = photo;
        return this;
    }

    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    public MicrosoftGraphContact withSingleValueExtendedProperties(List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphContact withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphContact withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    @Override
    public MicrosoftGraphContact withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    @Override
    public MicrosoftGraphContact withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphContact withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphContact withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.businessAddress() != null) {
            this.businessAddress().validate();
        }
        if (this.emailAddresses() != null) {
            this.emailAddresses().forEach(e -> e.validate());
        }
        if (this.homeAddress() != null) {
            this.homeAddress().validate();
        }
        if (this.otherAddress() != null) {
            this.otherAddress().validate();
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.multiValueExtendedProperties() != null) {
            this.multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (this.photo() != null) {
            this.photo().validate();
        }
        if (this.singleValueExtendedProperties() != null) {
            this.singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("categories", this.categories(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("changeKey", this.changeKey());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("assistantName", this.assistantName);
        jsonWriter.writeStringField("birthday", this.birthday == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.birthday));
        jsonWriter.writeJsonField("businessAddress", (JsonSerializable)this.businessAddress);
        jsonWriter.writeStringField("businessHomePage", this.businessHomePage);
        jsonWriter.writeArrayField("businessPhones", this.businessPhones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("children", this.children, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("companyName", this.companyName);
        jsonWriter.writeStringField("department", this.department);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("fileAs", this.fileAs);
        jsonWriter.writeStringField("generation", this.generation);
        jsonWriter.writeStringField("givenName", this.givenName);
        jsonWriter.writeJsonField("homeAddress", (JsonSerializable)this.homeAddress);
        jsonWriter.writeArrayField("homePhones", this.homePhones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("imAddresses", this.imAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("initials", this.initials);
        jsonWriter.writeStringField("jobTitle", this.jobTitle);
        jsonWriter.writeStringField("manager", this.manager);
        jsonWriter.writeStringField("middleName", this.middleName);
        jsonWriter.writeStringField("mobilePhone", this.mobilePhone);
        jsonWriter.writeStringField("nickName", this.nickName);
        jsonWriter.writeStringField("officeLocation", this.officeLocation);
        jsonWriter.writeJsonField("otherAddress", (JsonSerializable)this.otherAddress);
        jsonWriter.writeStringField("parentFolderId", this.parentFolderId);
        jsonWriter.writeStringField("personalNotes", this.personalNotes);
        jsonWriter.writeStringField("profession", this.profession);
        jsonWriter.writeStringField("spouseName", this.spouseName);
        jsonWriter.writeStringField("surname", this.surname);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("yomiCompanyName", this.yomiCompanyName);
        jsonWriter.writeStringField("yomiGivenName", this.yomiGivenName);
        jsonWriter.writeStringField("yomiSurname", this.yomiSurname);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("photo", (JsonSerializable)this.photo);
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphContact fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphContact)jsonReader.readObject(reader -> {
            MicrosoftGraphContact deserializedMicrosoftGraphContact = new MicrosoftGraphContact();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.withId(reader.getString());
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphContact.withCategories(categories);
                    continue;
                }
                if ("changeKey".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.withChangeKey(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("assistantName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.assistantName = reader.getString();
                    continue;
                }
                if ("birthday".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.birthday = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("businessAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.businessAddress = MicrosoftGraphPhysicalAddress.fromJson(reader);
                    continue;
                }
                if ("businessHomePage".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.businessHomePage = reader.getString();
                    continue;
                }
                if ("businessPhones".equals(fieldName)) {
                    List businessPhones;
                    deserializedMicrosoftGraphContact.businessPhones = businessPhones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("children".equals(fieldName)) {
                    List children;
                    deserializedMicrosoftGraphContact.children = children = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("companyName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.companyName = reader.getString();
                    continue;
                }
                if ("department".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.department = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.displayName = reader.getString();
                    continue;
                }
                if ("emailAddresses".equals(fieldName)) {
                    List emailAddresses;
                    deserializedMicrosoftGraphContact.emailAddresses = emailAddresses = reader.readArray(reader1 -> MicrosoftGraphEmailAddress.fromJson(reader1));
                    continue;
                }
                if ("fileAs".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.fileAs = reader.getString();
                    continue;
                }
                if ("generation".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.generation = reader.getString();
                    continue;
                }
                if ("givenName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.givenName = reader.getString();
                    continue;
                }
                if ("homeAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.homeAddress = MicrosoftGraphPhysicalAddress.fromJson(reader);
                    continue;
                }
                if ("homePhones".equals(fieldName)) {
                    List homePhones;
                    deserializedMicrosoftGraphContact.homePhones = homePhones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("imAddresses".equals(fieldName)) {
                    List imAddresses;
                    deserializedMicrosoftGraphContact.imAddresses = imAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("initials".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.initials = reader.getString();
                    continue;
                }
                if ("jobTitle".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.jobTitle = reader.getString();
                    continue;
                }
                if ("manager".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.manager = reader.getString();
                    continue;
                }
                if ("middleName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.middleName = reader.getString();
                    continue;
                }
                if ("mobilePhone".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.mobilePhone = reader.getString();
                    continue;
                }
                if ("nickName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.nickName = reader.getString();
                    continue;
                }
                if ("officeLocation".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.officeLocation = reader.getString();
                    continue;
                }
                if ("otherAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.otherAddress = MicrosoftGraphPhysicalAddress.fromJson(reader);
                    continue;
                }
                if ("parentFolderId".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.parentFolderId = reader.getString();
                    continue;
                }
                if ("personalNotes".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.personalNotes = reader.getString();
                    continue;
                }
                if ("profession".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.profession = reader.getString();
                    continue;
                }
                if ("spouseName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.spouseName = reader.getString();
                    continue;
                }
                if ("surname".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.surname = reader.getString();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.title = reader.getString();
                    continue;
                }
                if ("yomiCompanyName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.yomiCompanyName = reader.getString();
                    continue;
                }
                if ("yomiGivenName".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.yomiGivenName = reader.getString();
                    continue;
                }
                if ("yomiSurname".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.yomiSurname = reader.getString();
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedMicrosoftGraphContact.extensions = extensions = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    continue;
                }
                if ("multiValueExtendedProperties".equals(fieldName)) {
                    List multiValueExtendedProperties;
                    deserializedMicrosoftGraphContact.multiValueExtendedProperties = multiValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if ("photo".equals(fieldName)) {
                    deserializedMicrosoftGraphContact.photo = MicrosoftGraphProfilePhoto.fromJson(reader);
                    continue;
                }
                if ("singleValueExtendedProperties".equals(fieldName)) {
                    List singleValueExtendedProperties;
                    deserializedMicrosoftGraphContact.singleValueExtendedProperties = singleValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphContact.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphContact;
        });
    }
}

