/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.NotificationDeliveryMechanism;
import com.azure.resourcemanager.authorization.models.NotificationLevel;
import com.azure.resourcemanager.authorization.models.RecipientType;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRuleTarget;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRuleType;
import java.io.IOException;
import java.util.List;

public final class RoleManagementPolicyNotificationRule
extends RoleManagementPolicyRule {
    private RoleManagementPolicyRuleType ruleType = RoleManagementPolicyRuleType.ROLE_MANAGEMENT_POLICY_NOTIFICATION_RULE;
    private NotificationDeliveryMechanism notificationType;
    private NotificationLevel notificationLevel;
    private RecipientType recipientType;
    private List<String> notificationRecipients;
    private Boolean isDefaultRecipientsEnabled;

    @Override
    public RoleManagementPolicyRuleType ruleType() {
        return this.ruleType;
    }

    public NotificationDeliveryMechanism notificationType() {
        return this.notificationType;
    }

    public RoleManagementPolicyNotificationRule withNotificationType(NotificationDeliveryMechanism notificationType) {
        this.notificationType = notificationType;
        return this;
    }

    public NotificationLevel notificationLevel() {
        return this.notificationLevel;
    }

    public RoleManagementPolicyNotificationRule withNotificationLevel(NotificationLevel notificationLevel) {
        this.notificationLevel = notificationLevel;
        return this;
    }

    public RecipientType recipientType() {
        return this.recipientType;
    }

    public RoleManagementPolicyNotificationRule withRecipientType(RecipientType recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    public List<String> notificationRecipients() {
        return this.notificationRecipients;
    }

    public RoleManagementPolicyNotificationRule withNotificationRecipients(List<String> notificationRecipients) {
        this.notificationRecipients = notificationRecipients;
        return this;
    }

    public Boolean isDefaultRecipientsEnabled() {
        return this.isDefaultRecipientsEnabled;
    }

    public RoleManagementPolicyNotificationRule withIsDefaultRecipientsEnabled(Boolean isDefaultRecipientsEnabled) {
        this.isDefaultRecipientsEnabled = isDefaultRecipientsEnabled;
        return this;
    }

    @Override
    public RoleManagementPolicyNotificationRule withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public RoleManagementPolicyNotificationRule withTarget(RoleManagementPolicyRuleTarget target) {
        super.withTarget(target);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target());
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeStringField("notificationType", this.notificationType == null ? null : this.notificationType.toString());
        jsonWriter.writeStringField("notificationLevel", this.notificationLevel == null ? null : this.notificationLevel.toString());
        jsonWriter.writeStringField("recipientType", this.recipientType == null ? null : this.recipientType.toString());
        jsonWriter.writeArrayField("notificationRecipients", this.notificationRecipients, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isDefaultRecipientsEnabled", this.isDefaultRecipientsEnabled);
        return jsonWriter.writeEndObject();
    }

    public static RoleManagementPolicyNotificationRule fromJson(JsonReader jsonReader) throws IOException {
        return (RoleManagementPolicyNotificationRule)jsonReader.readObject(reader -> {
            RoleManagementPolicyNotificationRule deserializedRoleManagementPolicyNotificationRule = new RoleManagementPolicyNotificationRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.withId(reader.getString());
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.withTarget(RoleManagementPolicyRuleTarget.fromJson(reader));
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.ruleType = RoleManagementPolicyRuleType.fromString(reader.getString());
                    continue;
                }
                if ("notificationType".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.notificationType = NotificationDeliveryMechanism.fromString(reader.getString());
                    continue;
                }
                if ("notificationLevel".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.notificationLevel = NotificationLevel.fromString(reader.getString());
                    continue;
                }
                if ("recipientType".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.recipientType = RecipientType.fromString(reader.getString());
                    continue;
                }
                if ("notificationRecipients".equals(fieldName)) {
                    List notificationRecipients;
                    deserializedRoleManagementPolicyNotificationRule.notificationRecipients = notificationRecipients = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isDefaultRecipientsEnabled".equals(fieldName)) {
                    deserializedRoleManagementPolicyNotificationRule.isDefaultRecipientsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleManagementPolicyNotificationRule;
        });
    }
}

