/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChangeTrackedEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeOffItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphTimeOff
extends MicrosoftGraphChangeTrackedEntity {
    private MicrosoftGraphTimeOffItem draftTimeOff;
    private MicrosoftGraphTimeOffItem sharedTimeOff;
    private String userId;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphTimeOffItem draftTimeOff() {
        return this.draftTimeOff;
    }

    public MicrosoftGraphTimeOff withDraftTimeOff(MicrosoftGraphTimeOffItem draftTimeOff) {
        this.draftTimeOff = draftTimeOff;
        return this;
    }

    public MicrosoftGraphTimeOffItem sharedTimeOff() {
        return this.sharedTimeOff;
    }

    public MicrosoftGraphTimeOff withSharedTimeOff(MicrosoftGraphTimeOffItem sharedTimeOff) {
        this.sharedTimeOff = sharedTimeOff;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public MicrosoftGraphTimeOff withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTimeOff withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTimeOff withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOff withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOff withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphTimeOff withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.draftTimeOff() != null) {
            this.draftTimeOff().validate();
        }
        if (this.sharedTimeOff() != null) {
            this.sharedTimeOff().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeJsonField("draftTimeOff", (JsonSerializable)this.draftTimeOff);
        jsonWriter.writeJsonField("sharedTimeOff", (JsonSerializable)this.sharedTimeOff);
        jsonWriter.writeStringField("userId", this.userId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTimeOff fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTimeOff)jsonReader.readObject(reader -> {
            MicrosoftGraphTimeOff deserializedMicrosoftGraphTimeOff = new MicrosoftGraphTimeOff();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withId(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("draftTimeOff".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.draftTimeOff = MicrosoftGraphTimeOffItem.fromJson(reader);
                    continue;
                }
                if ("sharedTimeOff".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.sharedTimeOff = MicrosoftGraphTimeOffItem.fromJson(reader);
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeOff.userId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTimeOff.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTimeOff;
        });
    }
}

