/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphComplianceStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSettingSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphDeviceConfigurationSettingState
implements JsonSerializable<MicrosoftGraphDeviceConfigurationSettingState> {
    private String currentValue;
    private Long errorCode;
    private String errorDescription;
    private String instanceDisplayName;
    private String setting;
    private String settingName;
    private List<MicrosoftGraphSettingSource> sources;
    private MicrosoftGraphComplianceStatus state;
    private String userEmail;
    private String userId;
    private String username;
    private String userPrincipalName;
    private Map<String, Object> additionalProperties;

    public String currentValue() {
        return this.currentValue;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withCurrentValue(String currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    public Long errorCode() {
        return this.errorCode;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withErrorCode(Long errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    public String instanceDisplayName() {
        return this.instanceDisplayName;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withInstanceDisplayName(String instanceDisplayName) {
        this.instanceDisplayName = instanceDisplayName;
        return this;
    }

    public String setting() {
        return this.setting;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withSetting(String setting) {
        this.setting = setting;
        return this;
    }

    public String settingName() {
        return this.settingName;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withSettingName(String settingName) {
        this.settingName = settingName;
        return this;
    }

    public List<MicrosoftGraphSettingSource> sources() {
        return this.sources;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withSources(List<MicrosoftGraphSettingSource> sources) {
        this.sources = sources;
        return this;
    }

    public MicrosoftGraphComplianceStatus state() {
        return this.state;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withState(MicrosoftGraphComplianceStatus state) {
        this.state = state;
        return this;
    }

    public String userEmail() {
        return this.userEmail;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withUserEmail(String userEmail) {
        this.userEmail = userEmail;
        return this;
    }

    public String userId() {
        return this.userId;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String username() {
        return this.username;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withUsername(String username) {
        this.username = username;
        return this;
    }

    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphDeviceConfigurationSettingState withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.sources() != null) {
            this.sources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("currentValue", this.currentValue);
        jsonWriter.writeNumberField("errorCode", (Number)this.errorCode);
        jsonWriter.writeStringField("errorDescription", this.errorDescription);
        jsonWriter.writeStringField("instanceDisplayName", this.instanceDisplayName);
        jsonWriter.writeStringField("setting", this.setting);
        jsonWriter.writeStringField("settingName", this.settingName);
        jsonWriter.writeArrayField("sources", this.sources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("userEmail", this.userEmail);
        jsonWriter.writeStringField("userId", this.userId);
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("userPrincipalName", this.userPrincipalName);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphDeviceConfigurationSettingState fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphDeviceConfigurationSettingState)jsonReader.readObject(reader -> {
            MicrosoftGraphDeviceConfigurationSettingState deserializedMicrosoftGraphDeviceConfigurationSettingState = new MicrosoftGraphDeviceConfigurationSettingState();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentValue".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.currentValue = reader.getString();
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.errorCode = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("errorDescription".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.errorDescription = reader.getString();
                    continue;
                }
                if ("instanceDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.instanceDisplayName = reader.getString();
                    continue;
                }
                if ("setting".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.setting = reader.getString();
                    continue;
                }
                if ("settingName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.settingName = reader.getString();
                    continue;
                }
                if ("sources".equals(fieldName)) {
                    List sources;
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.sources = sources = reader.readArray(reader1 -> MicrosoftGraphSettingSource.fromJson(reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.state = MicrosoftGraphComplianceStatus.fromString(reader.getString());
                    continue;
                }
                if ("userEmail".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.userEmail = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.userId = reader.getString();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.username = reader.getString();
                    continue;
                }
                if ("userPrincipalName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceConfigurationSettingState.userPrincipalName = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphDeviceConfigurationSettingState.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphDeviceConfigurationSettingState;
        });
    }
}

