/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.UserSet;
import java.io.IOException;
import java.util.List;

public final class ApprovalStage
implements JsonSerializable<ApprovalStage> {
    private Integer approvalStageTimeOutInDays;
    private Boolean isApproverJustificationRequired;
    private Integer escalationTimeInMinutes;
    private List<UserSet> primaryApprovers;
    private Boolean isEscalationEnabled;
    private List<UserSet> escalationApprovers;

    public Integer approvalStageTimeOutInDays() {
        return this.approvalStageTimeOutInDays;
    }

    public ApprovalStage withApprovalStageTimeOutInDays(Integer approvalStageTimeOutInDays) {
        this.approvalStageTimeOutInDays = approvalStageTimeOutInDays;
        return this;
    }

    public Boolean isApproverJustificationRequired() {
        return this.isApproverJustificationRequired;
    }

    public ApprovalStage withIsApproverJustificationRequired(Boolean isApproverJustificationRequired) {
        this.isApproverJustificationRequired = isApproverJustificationRequired;
        return this;
    }

    public Integer escalationTimeInMinutes() {
        return this.escalationTimeInMinutes;
    }

    public ApprovalStage withEscalationTimeInMinutes(Integer escalationTimeInMinutes) {
        this.escalationTimeInMinutes = escalationTimeInMinutes;
        return this;
    }

    public List<UserSet> primaryApprovers() {
        return this.primaryApprovers;
    }

    public ApprovalStage withPrimaryApprovers(List<UserSet> primaryApprovers) {
        this.primaryApprovers = primaryApprovers;
        return this;
    }

    public Boolean isEscalationEnabled() {
        return this.isEscalationEnabled;
    }

    public ApprovalStage withIsEscalationEnabled(Boolean isEscalationEnabled) {
        this.isEscalationEnabled = isEscalationEnabled;
        return this;
    }

    public List<UserSet> escalationApprovers() {
        return this.escalationApprovers;
    }

    public ApprovalStage withEscalationApprovers(List<UserSet> escalationApprovers) {
        this.escalationApprovers = escalationApprovers;
        return this;
    }

    public void validate() {
        if (this.primaryApprovers() != null) {
            this.primaryApprovers().forEach(e -> e.validate());
        }
        if (this.escalationApprovers() != null) {
            this.escalationApprovers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("approvalStageTimeOutInDays", (Number)this.approvalStageTimeOutInDays);
        jsonWriter.writeBooleanField("isApproverJustificationRequired", this.isApproverJustificationRequired);
        jsonWriter.writeNumberField("escalationTimeInMinutes", (Number)this.escalationTimeInMinutes);
        jsonWriter.writeArrayField("primaryApprovers", this.primaryApprovers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isEscalationEnabled", this.isEscalationEnabled);
        jsonWriter.writeArrayField("escalationApprovers", this.escalationApprovers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApprovalStage fromJson(JsonReader jsonReader) throws IOException {
        return (ApprovalStage)jsonReader.readObject(reader -> {
            ApprovalStage deserializedApprovalStage = new ApprovalStage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("approvalStageTimeOutInDays".equals(fieldName)) {
                    deserializedApprovalStage.approvalStageTimeOutInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isApproverJustificationRequired".equals(fieldName)) {
                    deserializedApprovalStage.isApproverJustificationRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("escalationTimeInMinutes".equals(fieldName)) {
                    deserializedApprovalStage.escalationTimeInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("primaryApprovers".equals(fieldName)) {
                    List primaryApprovers;
                    deserializedApprovalStage.primaryApprovers = primaryApprovers = reader.readArray(reader1 -> UserSet.fromJson(reader1));
                    continue;
                }
                if ("isEscalationEnabled".equals(fieldName)) {
                    deserializedApprovalStage.isEscalationEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("escalationApprovers".equals(fieldName)) {
                    List escalationApprovers;
                    deserializedApprovalStage.escalationApprovers = escalationApprovers = reader.readArray(reader1 -> UserSet.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApprovalStage;
        });
    }
}

