/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.MemberType;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RoleEligibilityScheduleInstanceProperties
implements JsonSerializable<RoleEligibilityScheduleInstanceProperties> {
    private String scope;
    private String roleDefinitionId;
    private String principalId;
    private PrincipalType principalType;
    private String roleEligibilityScheduleId;
    private Status status;
    private OffsetDateTime startDateTime;
    private OffsetDateTime endDateTime;
    private MemberType memberType;
    private String condition;
    private String conditionVersion;
    private OffsetDateTime createdOn;
    private ExpandedProperties expandedProperties;

    public String scope() {
        return this.scope;
    }

    public RoleEligibilityScheduleInstanceProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public RoleEligibilityScheduleInstanceProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleEligibilityScheduleInstanceProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public RoleEligibilityScheduleInstanceProperties withPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
        return this;
    }

    public String roleEligibilityScheduleId() {
        return this.roleEligibilityScheduleId;
    }

    public RoleEligibilityScheduleInstanceProperties withRoleEligibilityScheduleId(String roleEligibilityScheduleId) {
        this.roleEligibilityScheduleId = roleEligibilityScheduleId;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public RoleEligibilityScheduleInstanceProperties withStatus(Status status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public RoleEligibilityScheduleInstanceProperties withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    public RoleEligibilityScheduleInstanceProperties withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public MemberType memberType() {
        return this.memberType;
    }

    public RoleEligibilityScheduleInstanceProperties withMemberType(MemberType memberType) {
        this.memberType = memberType;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RoleEligibilityScheduleInstanceProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public RoleEligibilityScheduleInstanceProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public RoleEligibilityScheduleInstanceProperties withCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    public ExpandedProperties expandedProperties() {
        return this.expandedProperties;
    }

    public RoleEligibilityScheduleInstanceProperties withExpandedProperties(ExpandedProperties expandedProperties) {
        this.expandedProperties = expandedProperties;
        return this;
    }

    public void validate() {
        if (this.expandedProperties() != null) {
            this.expandedProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("principalType", this.principalType == null ? null : this.principalType.toString());
        jsonWriter.writeStringField("roleEligibilityScheduleId", this.roleEligibilityScheduleId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("endDateTime", this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("memberType", this.memberType == null ? null : this.memberType.toString());
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        jsonWriter.writeStringField("createdOn", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeJsonField("expandedProperties", (JsonSerializable)this.expandedProperties);
        return jsonWriter.writeEndObject();
    }

    public static RoleEligibilityScheduleInstanceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleEligibilityScheduleInstanceProperties)jsonReader.readObject(reader -> {
            RoleEligibilityScheduleInstanceProperties deserializedRoleEligibilityScheduleInstanceProperties = new RoleEligibilityScheduleInstanceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scope".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.scope = reader.getString();
                    continue;
                }
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.roleDefinitionId = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.principalId = reader.getString();
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("roleEligibilityScheduleId".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.roleEligibilityScheduleId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("memberType".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.memberType = MemberType.fromString(reader.getString());
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.condition = reader.getString();
                    continue;
                }
                if ("conditionVersion".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.conditionVersion = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expandedProperties".equals(fieldName)) {
                    deserializedRoleEligibilityScheduleInstanceProperties.expandedProperties = ExpandedProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleEligibilityScheduleInstanceProperties;
        });
    }
}

