/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAudioConferencing;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphChatInfo;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLobbyBypassSettings;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMeetingParticipants;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnlineMeetingPresenters;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphOnlineMeeting
extends MicrosoftGraphEntity {
    private MicrosoftGraphOnlineMeetingPresenters allowedPresenters;
    private MicrosoftGraphAudioConferencing audioConferencing;
    private MicrosoftGraphChatInfo chatInfo;
    private OffsetDateTime creationDateTime;
    private OffsetDateTime endDateTime;
    private String externalId;
    private Boolean isEntryExitAnnounced;
    private MicrosoftGraphItemBody joinInformation;
    private String joinWebUrl;
    private MicrosoftGraphLobbyBypassSettings lobbyBypassSettings;
    private MicrosoftGraphMeetingParticipants participants;
    private OffsetDateTime startDateTime;
    private String subject;
    private String videoTeleconferenceId;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphOnlineMeetingPresenters allowedPresenters() {
        return this.allowedPresenters;
    }

    public MicrosoftGraphOnlineMeeting withAllowedPresenters(MicrosoftGraphOnlineMeetingPresenters allowedPresenters) {
        this.allowedPresenters = allowedPresenters;
        return this;
    }

    public MicrosoftGraphAudioConferencing audioConferencing() {
        return this.audioConferencing;
    }

    public MicrosoftGraphOnlineMeeting withAudioConferencing(MicrosoftGraphAudioConferencing audioConferencing) {
        this.audioConferencing = audioConferencing;
        return this;
    }

    public MicrosoftGraphChatInfo chatInfo() {
        return this.chatInfo;
    }

    public MicrosoftGraphOnlineMeeting withChatInfo(MicrosoftGraphChatInfo chatInfo) {
        this.chatInfo = chatInfo;
        return this;
    }

    public OffsetDateTime creationDateTime() {
        return this.creationDateTime;
    }

    public MicrosoftGraphOnlineMeeting withCreationDateTime(OffsetDateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    public MicrosoftGraphOnlineMeeting withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public String externalId() {
        return this.externalId;
    }

    public MicrosoftGraphOnlineMeeting withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public Boolean isEntryExitAnnounced() {
        return this.isEntryExitAnnounced;
    }

    public MicrosoftGraphOnlineMeeting withIsEntryExitAnnounced(Boolean isEntryExitAnnounced) {
        this.isEntryExitAnnounced = isEntryExitAnnounced;
        return this;
    }

    public MicrosoftGraphItemBody joinInformation() {
        return this.joinInformation;
    }

    public MicrosoftGraphOnlineMeeting withJoinInformation(MicrosoftGraphItemBody joinInformation) {
        this.joinInformation = joinInformation;
        return this;
    }

    public String joinWebUrl() {
        return this.joinWebUrl;
    }

    public MicrosoftGraphOnlineMeeting withJoinWebUrl(String joinWebUrl) {
        this.joinWebUrl = joinWebUrl;
        return this;
    }

    public MicrosoftGraphLobbyBypassSettings lobbyBypassSettings() {
        return this.lobbyBypassSettings;
    }

    public MicrosoftGraphOnlineMeeting withLobbyBypassSettings(MicrosoftGraphLobbyBypassSettings lobbyBypassSettings) {
        this.lobbyBypassSettings = lobbyBypassSettings;
        return this;
    }

    public MicrosoftGraphMeetingParticipants participants() {
        return this.participants;
    }

    public MicrosoftGraphOnlineMeeting withParticipants(MicrosoftGraphMeetingParticipants participants) {
        this.participants = participants;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public MicrosoftGraphOnlineMeeting withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public MicrosoftGraphOnlineMeeting withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String videoTeleconferenceId() {
        return this.videoTeleconferenceId;
    }

    public MicrosoftGraphOnlineMeeting withVideoTeleconferenceId(String videoTeleconferenceId) {
        this.videoTeleconferenceId = videoTeleconferenceId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnlineMeeting withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnlineMeeting withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.audioConferencing() != null) {
            this.audioConferencing().validate();
        }
        if (this.chatInfo() != null) {
            this.chatInfo().validate();
        }
        if (this.joinInformation() != null) {
            this.joinInformation().validate();
        }
        if (this.lobbyBypassSettings() != null) {
            this.lobbyBypassSettings().validate();
        }
        if (this.participants() != null) {
            this.participants().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("allowedPresenters", this.allowedPresenters == null ? null : this.allowedPresenters.toString());
        jsonWriter.writeJsonField("audioConferencing", (JsonSerializable)this.audioConferencing);
        jsonWriter.writeJsonField("chatInfo", (JsonSerializable)this.chatInfo);
        jsonWriter.writeStringField("creationDateTime", this.creationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationDateTime));
        jsonWriter.writeStringField("endDateTime", this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeStringField("externalId", this.externalId);
        jsonWriter.writeBooleanField("isEntryExitAnnounced", this.isEntryExitAnnounced);
        jsonWriter.writeJsonField("joinInformation", (JsonSerializable)this.joinInformation);
        jsonWriter.writeStringField("joinWebUrl", this.joinWebUrl);
        jsonWriter.writeJsonField("lobbyBypassSettings", (JsonSerializable)this.lobbyBypassSettings);
        jsonWriter.writeJsonField("participants", (JsonSerializable)this.participants);
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("videoTeleconferenceId", this.videoTeleconferenceId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnlineMeeting fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnlineMeeting)jsonReader.readObject(reader -> {
            MicrosoftGraphOnlineMeeting deserializedMicrosoftGraphOnlineMeeting = new MicrosoftGraphOnlineMeeting();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.withId(reader.getString());
                    continue;
                }
                if ("allowedPresenters".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.allowedPresenters = MicrosoftGraphOnlineMeetingPresenters.fromString(reader.getString());
                    continue;
                }
                if ("audioConferencing".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.audioConferencing = MicrosoftGraphAudioConferencing.fromJson(reader);
                    continue;
                }
                if ("chatInfo".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.chatInfo = MicrosoftGraphChatInfo.fromJson(reader);
                    continue;
                }
                if ("creationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.creationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("externalId".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.externalId = reader.getString();
                    continue;
                }
                if ("isEntryExitAnnounced".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.isEntryExitAnnounced = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("joinInformation".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.joinInformation = MicrosoftGraphItemBody.fromJson(reader);
                    continue;
                }
                if ("joinWebUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.joinWebUrl = reader.getString();
                    continue;
                }
                if ("lobbyBypassSettings".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.lobbyBypassSettings = MicrosoftGraphLobbyBypassSettings.fromJson(reader);
                    continue;
                }
                if ("participants".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.participants = MicrosoftGraphMeetingParticipants.fromJson(reader);
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.subject = reader.getString();
                    continue;
                }
                if ("videoTeleconferenceId".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeeting.videoTeleconferenceId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnlineMeeting.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnlineMeeting;
        });
    }
}

