/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphAttachment
extends MicrosoftGraphEntity {
    private String contentType;
    private Boolean isInline;
    private OffsetDateTime lastModifiedDateTime;
    private String name;
    private Integer size;
    private Map<String, Object> additionalProperties;

    public String contentType() {
        return this.contentType;
    }

    public MicrosoftGraphAttachment withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Boolean isInline() {
        return this.isInline;
    }

    public MicrosoftGraphAttachment withIsInline(Boolean isInline) {
        this.isInline = isInline;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphAttachment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MicrosoftGraphAttachment withName(String name) {
        this.name = name;
        return this;
    }

    public Integer size() {
        return this.size;
    }

    public MicrosoftGraphAttachment withSize(Integer size) {
        this.size = size;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphAttachment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphAttachment withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeBooleanField("isInline", this.isInline);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("size", (Number)this.size);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphAttachment)jsonReader.readObject(reader -> {
            MicrosoftGraphAttachment deserializedMicrosoftGraphAttachment = new MicrosoftGraphAttachment();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphAttachment.withId(reader.getString());
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedMicrosoftGraphAttachment.contentType = reader.getString();
                    continue;
                }
                if ("isInline".equals(fieldName)) {
                    deserializedMicrosoftGraphAttachment.isInline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAttachment.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphAttachment.name = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedMicrosoftGraphAttachment.size = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphAttachment.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphAttachment;
        });
    }
}

