/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsAddKeyRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsExpand;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsRemoveKeyRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsRemovePasswordRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationsSelect;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtensionProperty;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfHomeRealmDiscoveryPolicy;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfHomeRealmDiscoveryPolicy;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphHomeRealmDiscoveryPolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ApplicationsClientImpl
implements ApplicationsClient {
    private final ApplicationsService service;
    private final MicrosoftGraphClientImpl client;

    ApplicationsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ApplicationsService)RestProxy.create(ApplicationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(String applicationId, List<Get1ItemsItem> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, selectConverted, expandConverted, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOfWithResponseAsync(String applicationId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.getCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfAsync(String applicationId) {
        List<Get1ItemsItem> select = null;
        List<String> expand = null;
        return this.getCreatedOnBehalfOfWithResponseAsync(applicationId, select, expand).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getCreatedOnBehalfOfWithResponse(String applicationId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        return (Response)this.getCreatedOnBehalfOfWithResponseAsync(applicationId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getCreatedOnBehalfOf(String applicationId) {
        List<Get1ItemsItem> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getCreatedOnBehalfOfWithResponse(applicationId, select, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<String>> getRefCreatedOnBehalfOfWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getRefCreatedOnBehalfOfAsync(String applicationId) {
        return this.getRefCreatedOnBehalfOfWithResponseAsync(applicationId).flatMap(res -> Mono.justOrEmpty((Object)((String)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getRefCreatedOnBehalfOfWithResponse(String applicationId, Context context) {
        return (Response)this.getRefCreatedOnBehalfOfWithResponseAsync(applicationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getRefCreatedOnBehalfOf(String applicationId) {
        return (String)this.getRefCreatedOnBehalfOfWithResponse(applicationId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String applicationId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> setRefCreatedOnBehalfOfWithResponseAsync(String applicationId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setRefCreatedOnBehalfOfAsync(String applicationId, Map<String, Object> body) {
        return this.setRefCreatedOnBehalfOfWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setRefCreatedOnBehalfOfWithResponse(String applicationId, Map<String, Object> body, Context context) {
        return (Response)this.setRefCreatedOnBehalfOfWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setRefCreatedOnBehalfOf(String applicationId, Map<String, Object> body) {
        this.setRefCreatedOnBehalfOfWithResponse(applicationId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String applicationId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefCreatedOnBehalfOfWithResponseAsync(String applicationId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRefCreatedOnBehalfOf(this.client.getEndpoint(), applicationId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRefCreatedOnBehalfOfAsync(String applicationId) {
        String ifMatch = null;
        return this.deleteRefCreatedOnBehalfOfWithResponseAsync(applicationId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRefCreatedOnBehalfOfWithResponse(String applicationId, String ifMatch, Context context) {
        return (Response)this.deleteRefCreatedOnBehalfOfWithResponseAsync(applicationId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRefCreatedOnBehalfOf(String applicationId) {
        String ifMatch = null;
        this.deleteRefCreatedOnBehalfOfWithResponse(applicationId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listExtensionPropertiesSinglePageAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listExtensionProperties(this.client.getEndpoint(), applicationId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionProperty)res.getValue()).value(), ((CollectionOfExtensionProperty)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listExtensionPropertiesSinglePageAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listExtensionProperties(this.client.getEndpoint(), applicationId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionProperty)res.getValue()).value(), ((CollectionOfExtensionProperty)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionPropertyInner> listExtensionPropertiesAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionPropertiesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphExtensionPropertyInner> listExtensionPropertiesAsync(String applicationId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionPropertiesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphExtensionPropertyInner> listExtensionPropertiesAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionPropertiesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionPropertyInner> listExtensionProperties(String applicationId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ApplicationsOrderby> orderby = null;
        List<ApplicationsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionPropertiesAsync(applicationId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphExtensionPropertyInner> listExtensionProperties(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionPropertiesAsync(applicationId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionPropertyInner>> createExtensionPropertiesWithResponseAsync(String applicationId, MicrosoftGraphExtensionPropertyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensionProperties(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionPropertyInner>> createExtensionPropertiesWithResponseAsync(String applicationId, MicrosoftGraphExtensionPropertyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensionProperties(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionPropertyInner> createExtensionPropertiesAsync(String applicationId, MicrosoftGraphExtensionPropertyInner body) {
        return this.createExtensionPropertiesWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphExtensionPropertyInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionPropertyInner> createExtensionPropertiesWithResponse(String applicationId, MicrosoftGraphExtensionPropertyInner body, Context context) {
        return (Response)this.createExtensionPropertiesWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphExtensionPropertyInner createExtensionProperties(String applicationId, MicrosoftGraphExtensionPropertyInner body) {
        return (MicrosoftGraphExtensionPropertyInner)this.createExtensionPropertiesWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphExtensionPropertyInner>> getExtensionPropertiesWithResponseAsync(String applicationId, String extensionPropertyId, List<ApplicationsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.getExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, selectConverted, expandConverted, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphExtensionPropertyInner>> getExtensionPropertiesWithResponseAsync(String applicationId, String extensionPropertyId, List<ApplicationsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.getExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphExtensionPropertyInner> getExtensionPropertiesAsync(String applicationId, String extensionPropertyId) {
        List<ApplicationsSelect> select = null;
        List<String> expand = null;
        return this.getExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, select, expand).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphExtensionPropertyInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphExtensionPropertyInner> getExtensionPropertiesWithResponse(String applicationId, String extensionPropertyId, List<ApplicationsSelect> select, List<String> expand, Context context) {
        return (Response)this.getExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, select, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphExtensionPropertyInner getExtensionProperties(String applicationId, String extensionPropertyId) {
        List<ApplicationsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphExtensionPropertyInner)this.getExtensionPropertiesWithResponse(applicationId, extensionPropertyId, select, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateExtensionPropertiesWithResponseAsync(String applicationId, String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> updateExtensionPropertiesWithResponseAsync(String applicationId, String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateExtensionPropertiesAsync(String applicationId, String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body) {
        return this.updateExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateExtensionPropertiesWithResponse(String applicationId, String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body, Context context) {
        return (Response)this.updateExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateExtensionProperties(String applicationId, String extensionPropertyId, MicrosoftGraphExtensionPropertyInner body) {
        this.updateExtensionPropertiesWithResponse(applicationId, extensionPropertyId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteExtensionPropertiesWithResponseAsync(String applicationId, String extensionPropertyId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteExtensionPropertiesWithResponseAsync(String applicationId, String extensionPropertyId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (extensionPropertyId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionPropertyId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensionProperties(this.client.getEndpoint(), applicationId, extensionPropertyId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteExtensionPropertiesAsync(String applicationId, String extensionPropertyId) {
        String ifMatch = null;
        return this.deleteExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteExtensionPropertiesWithResponse(String applicationId, String extensionPropertyId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionPropertiesWithResponseAsync(applicationId, extensionPropertyId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteExtensionProperties(String applicationId, String extensionPropertyId) {
        String ifMatch = null;
        this.deleteExtensionPropertiesWithResponse(applicationId, extensionPropertyId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand) {
        return new PagedFlux(() -> this.listHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(String applicationId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand, Context context) {
        return new PagedFlux(() -> this.listHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(String applicationId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ApplicationsOrderby> orderby = null;
        List<ApplicationsSelect> select = null;
        List<ApplicationsExpand> expand = null;
        return new PagedIterable(this.listHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, List<ApplicationsSelect> select, List<ApplicationsExpand> expand, Context context) {
        return new PagedIterable(this.listHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesSinglePageAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(value -> Objects.toString(value, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby), nextLink -> this.listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String applicationId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby), nextLink -> this.listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefHomeRealmDiscoveryPoliciesSinglePageAsync(applicationId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String applicationId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ApplicationsOrderby> orderby = null;
        return new PagedIterable(this.listRefHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String applicationId, Integer top, Integer skip, String search, String filter, Boolean count, List<ApplicationsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefHomeRealmDiscoveryPoliciesAsync(applicationId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPoliciesWithResponseAsync(String applicationId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPoliciesWithResponseAsync(String applicationId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefHomeRealmDiscoveryPolicies(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesAsync(String applicationId, Map<String, Object> body) {
        return this.createRefHomeRealmDiscoveryPoliciesWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesWithResponse(String applicationId, Map<String, Object> body, Context context) {
        return (Response)this.createRefHomeRealmDiscoveryPoliciesWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> createRefHomeRealmDiscoveryPolicies(String applicationId, Map<String, Object> body) {
        return (Map)this.createRefHomeRealmDiscoveryPoliciesWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String applicationId, ApplicationsAddKeyRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addKey(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(String applicationId, ApplicationsAddKeyRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addKey(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphKeyCredentialInner> addKeyAsync(String applicationId, ApplicationsAddKeyRequestBodyInner body) {
        return this.addKeyWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphKeyCredentialInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphKeyCredentialInner> addKeyWithResponse(String applicationId, ApplicationsAddKeyRequestBodyInner body, Context context) {
        return (Response)this.addKeyWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphKeyCredentialInner addKey(String applicationId, ApplicationsAddKeyRequestBodyInner body) {
        return (MicrosoftGraphKeyCredentialInner)this.addKeyWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String applicationId, ApplicationsAddPasswordRequestBodyInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addPassword(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(String applicationId, ApplicationsAddPasswordRequestBodyInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addPassword(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphPasswordCredentialInner> addPasswordAsync(String applicationId, ApplicationsAddPasswordRequestBodyInner body) {
        return this.addPasswordWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphPasswordCredentialInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphPasswordCredentialInner> addPasswordWithResponse(String applicationId, ApplicationsAddPasswordRequestBodyInner body, Context context) {
        return (Response)this.addPasswordWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphPasswordCredentialInner addPassword(String applicationId, ApplicationsAddPasswordRequestBodyInner body) {
        return (MicrosoftGraphPasswordCredentialInner)this.addPasswordWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String applicationId, ApplicationsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String applicationId, ApplicationsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String applicationId, ApplicationsCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(String applicationId, ApplicationsCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberGroups(String applicationId, ApplicationsCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String applicationId, ApplicationsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String applicationId, ApplicationsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String applicationId, ApplicationsCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(String applicationId, ApplicationsCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> checkMemberObjects(String applicationId, ApplicationsCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String applicationId, ApplicationsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String applicationId, ApplicationsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String applicationId, ApplicationsGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(String applicationId, ApplicationsGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberGroups(String applicationId, ApplicationsGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String applicationId, ApplicationsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String applicationId, ApplicationsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String applicationId, ApplicationsGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(applicationId, body).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(String applicationId, ApplicationsGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<String> getMemberObjects(String applicationId, ApplicationsGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsWithResponse(applicationId, body, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeKeyWithResponseAsync(String applicationId, ApplicationsRemoveKeyRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removeKey(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removeKeyWithResponseAsync(String applicationId, ApplicationsRemoveKeyRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removeKey(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeKeyAsync(String applicationId, ApplicationsRemoveKeyRequestBody body) {
        return this.removeKeyWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeKeyWithResponse(String applicationId, ApplicationsRemoveKeyRequestBody body, Context context) {
        return (Response)this.removeKeyWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeKey(String applicationId, ApplicationsRemoveKeyRequestBody body) {
        this.removeKeyWithResponse(applicationId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removePasswordWithResponseAsync(String applicationId, ApplicationsRemovePasswordRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.removePassword(this.client.getEndpoint(), applicationId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> removePasswordWithResponseAsync(String applicationId, ApplicationsRemovePasswordRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.removePassword(this.client.getEndpoint(), applicationId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removePasswordAsync(String applicationId, ApplicationsRemovePasswordRequestBody body) {
        return this.removePasswordWithResponseAsync(applicationId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removePasswordWithResponse(String applicationId, ApplicationsRemovePasswordRequestBody body, Context context) {
        return (Response)this.removePasswordWithResponseAsync(applicationId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removePassword(String applicationId, ApplicationsRemovePasswordRequestBody body) {
        this.removePasswordWithResponse(applicationId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String applicationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), applicationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String applicationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (applicationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter applicationId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), applicationId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String applicationId) {
        return this.restoreWithResponseAsync(applicationId).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String applicationId, Context context) {
        return (Response)this.restoreWithResponseAsync(applicationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String applicationId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreWithResponse(applicationId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionProperty)res.getValue()).value(), ((CollectionOfExtensionProperty)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphExtensionPropertyInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtensionProperty)res.getValue()).value(), ((CollectionOfExtensionProperty)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listHomeRealmDiscoveryPoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphHomeRealmDiscoveryPolicyInner>> listHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listHomeRealmDiscoveryPoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefHomeRealmDiscoveryPoliciesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefHomeRealmDiscoveryPoliciesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefHomeRealmDiscoveryPoliciesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).value(), ((CollectionOfLinksOfHomeRealmDiscoveryPolicy)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    public static interface ApplicationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/createdOnBehalfOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<String>> getRefCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/applications/{application-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setRefCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/applications/{application-id}/createdOnBehalfOf/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRefCreatedOnBehalfOf(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/extensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtensionProperty>> listExtensionProperties(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/extensionProperties")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionPropertyInner>> createExtensionProperties(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") MicrosoftGraphExtensionPropertyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/extensionProperties/{extensionProperty-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionPropertyInner>> getExtensionProperties(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @PathParam(value="extensionProperty-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/applications/{application-id}/extensionProperties/{extensionProperty-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensionProperties(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @PathParam(value="extensionProperty-id") String var3, @BodyParam(value="application/json") MicrosoftGraphExtensionPropertyInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/applications/{application-id}/extensionProperties/{extensionProperty-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensionProperties(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @PathParam(value="extensionProperty-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/homeRealmDiscoveryPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfHomeRealmDiscoveryPolicy>> listHomeRealmDiscoveryPolicies(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/applications/{application-id}/homeRealmDiscoveryPolicies/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfHomeRealmDiscoveryPolicy>> listRefHomeRealmDiscoveryPolicies(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/homeRealmDiscoveryPolicies/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPolicies(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.addKey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphKeyCredentialInner>> addKey(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsAddKeyRequestBodyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.addPassword")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPassword(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsAddPasswordRequestBodyInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.removeKey")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> removeKey(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsRemoveKeyRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.removePassword")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> removePassword(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @BodyParam(value="application/json") ApplicationsRemovePasswordRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/applications/{application-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="application-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtensionProperty>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfHomeRealmDiscoveryPolicy>> listHomeRealmDiscoveryPoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfHomeRealmDiscoveryPolicy>> listRefHomeRealmDiscoveryPoliciesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

