/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DomainsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject9;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDomainDnsRecord;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDomainDnsRecord0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject8;
import com.azure.resourcemanager.authorization.fluent.models.DomainsForceDeleteRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DomainsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DomainsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainDnsRecordInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDomainInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class DomainsClientImpl
implements DomainsClient {
    private final ClientLogger logger = new ClientLogger(DomainsClientImpl.class);
    private final DomainsService service;
    private final MicrosoftGraphClientImpl client;

    DomainsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DomainsService)RestProxy.create(DomainsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDomainNameReferencesSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDomainNameReferences(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject9)res.getValue()).value(), ((CollectionOfDirectoryObject9)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDomainNameReferencesSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDomainNameReferences(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject9)res.getValue()).value(), ((CollectionOfDirectoryObject9)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listDomainNameReferencesAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDomainNameReferences(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DomainsOrderby> orderby = null;
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDomainNameReferences(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefDomainNameReferencesSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefDomainNameReferences(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefDomainNameReferencesSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefDomainNameReferences(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefDomainNameReferencesAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby), nextLink -> this.listRefDomainNameReferencesNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefDomainNameReferencesAsync(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby), nextLink -> this.listRefDomainNameReferencesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefDomainNameReferencesAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefDomainNameReferencesSinglePageAsync(domainId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefDomainNameReferencesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefDomainNameReferences(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DomainsOrderby> orderby = null;
        return new PagedIterable(this.listRefDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefDomainNameReferences(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefDomainNameReferencesAsync(domainId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefDomainNameReferencesWithResponseAsync(String domainId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefDomainNameReferences(this.client.getEndpoint(), domainId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefDomainNameReferencesWithResponseAsync(String domainId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefDomainNameReferences(this.client.getEndpoint(), domainId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefDomainNameReferencesAsync(String domainId, Map<String, Object> body) {
        return this.createRefDomainNameReferencesWithResponseAsync(domainId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefDomainNameReferences(String domainId, Map<String, Object> body) {
        return (Map)this.createRefDomainNameReferencesAsync(domainId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefDomainNameReferencesWithResponse(String domainId, Map<String, Object> body, Context context) {
        return (Response)this.createRefDomainNameReferencesWithResponseAsync(domainId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> forceDeleteWithResponseAsync(String domainId, DomainsForceDeleteRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.forceDelete(this.client.getEndpoint(), domainId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> forceDeleteWithResponseAsync(String domainId, DomainsForceDeleteRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.forceDelete(this.client.getEndpoint(), domainId, body, "application/json", context);
    }

    @Override
    public Mono<Void> forceDeleteAsync(String domainId, DomainsForceDeleteRequestBody body) {
        return this.forceDeleteWithResponseAsync(domainId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void forceDelete(String domainId, DomainsForceDeleteRequestBody body) {
        this.forceDeleteAsync(domainId, body).block();
    }

    @Override
    public Response<Void> forceDeleteWithResponse(String domainId, DomainsForceDeleteRequestBody body, Context context) {
        return (Response)this.forceDeleteWithResponseAsync(domainId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDomainInner>> verifyWithResponseAsync(String domainId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.verify(this.client.getEndpoint(), domainId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDomainInner>> verifyWithResponseAsync(String domainId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.verify(this.client.getEndpoint(), domainId, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDomainInner> verifyAsync(String domainId) {
        return this.verifyWithResponseAsync(domainId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDomainInner verify(String domainId) {
        return (MicrosoftGraphDomainInner)this.verifyAsync(domainId).block();
    }

    @Override
    public Response<MicrosoftGraphDomainInner> verifyWithResponse(String domainId, Context context) {
        return (Response)this.verifyWithResponseAsync(domainId, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listServiceConfigurationRecords(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord)res.getValue()).value(), ((CollectionOfDomainDnsRecord)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listServiceConfigurationRecords(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord)res.getValue()).value(), ((CollectionOfDomainDnsRecord)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listServiceConfigurationRecordsSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listServiceConfigurationRecordsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listServiceConfigurationRecordsSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listServiceConfigurationRecordsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecordsAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listServiceConfigurationRecordsSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listServiceConfigurationRecordsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecords(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DomainsOrderby> orderby = null;
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listServiceConfigurationRecordsAsync(domainId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listServiceConfigurationRecords(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listServiceConfigurationRecordsAsync(domainId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecordsWithResponseAsync(String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createServiceConfigurationRecords(this.client.getEndpoint(), domainId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecordsWithResponseAsync(String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createServiceConfigurationRecords(this.client.getEndpoint(), domainId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDomainDnsRecordInner> createServiceConfigurationRecordsAsync(String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return this.createServiceConfigurationRecordsWithResponseAsync(domainId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainDnsRecordInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDomainDnsRecordInner createServiceConfigurationRecords(String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return (MicrosoftGraphDomainDnsRecordInner)this.createServiceConfigurationRecordsAsync(domainId, body).block();
    }

    @Override
    public Response<MicrosoftGraphDomainDnsRecordInner> createServiceConfigurationRecordsWithResponse(String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return (Response)this.createServiceConfigurationRecordsWithResponseAsync(domainId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecordsWithResponseAsync(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getServiceConfigurationRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecordsWithResponseAsync(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getServiceConfigurationRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        return this.getServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainDnsRecordInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId) {
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return this.getServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainDnsRecordInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDomainDnsRecordInner getServiceConfigurationRecords(String domainId, String domainDnsRecordId) {
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDomainDnsRecordInner)this.getServiceConfigurationRecordsAsync(domainId, domainDnsRecordId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphDomainDnsRecordInner> getServiceConfigurationRecordsWithResponse(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        return (Response)this.getServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateServiceConfigurationRecordsWithResponseAsync(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateServiceConfigurationRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateServiceConfigurationRecordsWithResponseAsync(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateServiceConfigurationRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        return this.updateServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateServiceConfigurationRecords(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        this.updateServiceConfigurationRecordsAsync(domainId, domainDnsRecordId, body).block();
    }

    @Override
    public Response<Void> updateServiceConfigurationRecordsWithResponse(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return (Response)this.updateServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteServiceConfigurationRecordsWithResponseAsync(String domainId, String domainDnsRecordId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteServiceConfigurationRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteServiceConfigurationRecordsWithResponseAsync(String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteServiceConfigurationRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId, String ifMatch) {
        return this.deleteServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteServiceConfigurationRecordsAsync(String domainId, String domainDnsRecordId) {
        String ifMatch = null;
        return this.deleteServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteServiceConfigurationRecords(String domainId, String domainDnsRecordId) {
        String ifMatch = null;
        this.deleteServiceConfigurationRecordsAsync(domainId, domainDnsRecordId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteServiceConfigurationRecordsWithResponse(String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        return (Response)this.deleteServiceConfigurationRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listVerificationDnsRecords(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord0)res.getValue()).value(), ((CollectionOfDomainDnsRecord0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsSinglePageAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listVerificationDnsRecords(this.client.getEndpoint(), domainId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord0)res.getValue()).value(), ((CollectionOfDomainDnsRecord0)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listVerificationDnsRecordsSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listVerificationDnsRecordsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listVerificationDnsRecordsSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listVerificationDnsRecordsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecordsAsync(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listVerificationDnsRecordsSinglePageAsync(domainId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listVerificationDnsRecordsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecords(String domainId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DomainsOrderby> orderby = null;
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listVerificationDnsRecordsAsync(domainId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDomainDnsRecordInner> listVerificationDnsRecords(String domainId, Integer top, Integer skip, String search, String filter, Boolean count, List<DomainsOrderby> orderby, List<DomainsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listVerificationDnsRecordsAsync(domainId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecordsWithResponseAsync(String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createVerificationDnsRecords(this.client.getEndpoint(), domainId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecordsWithResponseAsync(String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createVerificationDnsRecords(this.client.getEndpoint(), domainId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDomainDnsRecordInner> createVerificationDnsRecordsAsync(String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return this.createVerificationDnsRecordsWithResponseAsync(domainId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainDnsRecordInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDomainDnsRecordInner createVerificationDnsRecords(String domainId, MicrosoftGraphDomainDnsRecordInner body) {
        return (MicrosoftGraphDomainDnsRecordInner)this.createVerificationDnsRecordsAsync(domainId, body).block();
    }

    @Override
    public Response<MicrosoftGraphDomainDnsRecordInner> createVerificationDnsRecordsWithResponse(String domainId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return (Response)this.createVerificationDnsRecordsWithResponseAsync(domainId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecordsWithResponseAsync(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getVerificationDnsRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecordsWithResponseAsync(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getVerificationDnsRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand) {
        return this.getVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainDnsRecordInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId) {
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return this.getVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDomainDnsRecordInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDomainDnsRecordInner getVerificationDnsRecords(String domainId, String domainDnsRecordId) {
        List<DomainsSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDomainDnsRecordInner)this.getVerificationDnsRecordsAsync(domainId, domainDnsRecordId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphDomainDnsRecordInner> getVerificationDnsRecordsWithResponse(String domainId, String domainDnsRecordId, List<DomainsSelect> select, List<String> expand, Context context) {
        return (Response)this.getVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateVerificationDnsRecordsWithResponseAsync(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateVerificationDnsRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateVerificationDnsRecordsWithResponseAsync(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateVerificationDnsRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        return this.updateVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateVerificationDnsRecords(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body) {
        this.updateVerificationDnsRecordsAsync(domainId, domainDnsRecordId, body).block();
    }

    @Override
    public Response<Void> updateVerificationDnsRecordsWithResponse(String domainId, String domainDnsRecordId, MicrosoftGraphDomainDnsRecordInner body, Context context) {
        return (Response)this.updateVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteVerificationDnsRecordsWithResponseAsync(String domainId, String domainDnsRecordId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteVerificationDnsRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteVerificationDnsRecordsWithResponseAsync(String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainId is required and cannot be null."));
        }
        if (domainDnsRecordId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainDnsRecordId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteVerificationDnsRecords(this.client.getEndpoint(), domainId, domainDnsRecordId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId, String ifMatch) {
        return this.deleteVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteVerificationDnsRecordsAsync(String domainId, String domainDnsRecordId) {
        String ifMatch = null;
        return this.deleteVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteVerificationDnsRecords(String domainId, String domainDnsRecordId) {
        String ifMatch = null;
        this.deleteVerificationDnsRecordsAsync(domainId, domainDnsRecordId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteVerificationDnsRecordsWithResponse(String domainId, String domainDnsRecordId, String ifMatch, Context context) {
        return (Response)this.deleteVerificationDnsRecordsWithResponseAsync(domainId, domainDnsRecordId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject9)res.getValue()).value(), ((CollectionOfDirectoryObject9)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject9)res.getValue()).value(), ((CollectionOfDirectoryObject9)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefDomainNameReferencesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefDomainNameReferencesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefDomainNameReferencesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefDomainNameReferencesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject8)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listServiceConfigurationRecordsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord)res.getValue()).value(), ((CollectionOfDomainDnsRecord)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listServiceConfigurationRecordsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listServiceConfigurationRecordsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord)res.getValue()).value(), ((CollectionOfDomainDnsRecord)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listVerificationDnsRecordsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord0)res.getValue()).value(), ((CollectionOfDomainDnsRecord0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDomainDnsRecordInner>> listVerificationDnsRecordsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listVerificationDnsRecordsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDomainDnsRecord0)res.getValue()).value(), ((CollectionOfDomainDnsRecord0)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}/domainNameReferences")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject9>> listDomainNameReferences(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}/domainNameReferences/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject8>> listRefDomainNameReferences(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/domains/{domain-id}/domainNameReferences/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefDomainNameReferences(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/domains/{domain-id}/microsoft.graph.forceDelete")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> forceDelete(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @BodyParam(value="application/json") DomainsForceDeleteRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/domains/{domain-id}/microsoft.graph.verify")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainInner>> verify(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}/serviceConfigurationRecords")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDomainDnsRecord>> listServiceConfigurationRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/domains/{domain-id}/serviceConfigurationRecords")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createServiceConfigurationRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDomainDnsRecordInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}/serviceConfigurationRecords/{domainDnsRecord-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getServiceConfigurationRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @PathParam(value="domainDnsRecord-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/domains/{domain-id}/serviceConfigurationRecords/{domainDnsRecord-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateServiceConfigurationRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @PathParam(value="domainDnsRecord-id") String var3, @BodyParam(value="application/json") MicrosoftGraphDomainDnsRecordInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/domains/{domain-id}/serviceConfigurationRecords/{domainDnsRecord-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteServiceConfigurationRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @PathParam(value="domainDnsRecord-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}/verificationDnsRecords")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDomainDnsRecord0>> listVerificationDnsRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/domains/{domain-id}/verificationDnsRecords")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> createVerificationDnsRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDomainDnsRecordInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/domains/{domain-id}/verificationDnsRecords/{domainDnsRecord-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDomainDnsRecordInner>> getVerificationDnsRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @PathParam(value="domainDnsRecord-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/domains/{domain-id}/verificationDnsRecords/{domainDnsRecord-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateVerificationDnsRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @PathParam(value="domainDnsRecord-id") String var3, @BodyParam(value="application/json") MicrosoftGraphDomainDnsRecordInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/domains/{domain-id}/verificationDnsRecords/{domainDnsRecord-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteVerificationDnsRecords(@HostParam(value="$host") String var1, @PathParam(value="domain-id") String var2, @PathParam(value="domainDnsRecord-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject9>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject8>> listRefDomainNameReferencesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDomainDnsRecord>> listServiceConfigurationRecordsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDomainDnsRecord0>> listVerificationDnsRecordsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

