/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryRoleTemplatesDirectoryRoleTemplatesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryRoleTemplate;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesDirectoryRoleTemplateOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesDirectoryRoleTemplateSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleTemplateInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl
implements DirectoryRoleTemplatesDirectoryRoleTemplatesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl.class);
    private final DirectoryRoleTemplatesDirectoryRoleTemplatesService service;
    private final MicrosoftGraphClientImpl client;

    DirectoryRoleTemplatesDirectoryRoleTemplatesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DirectoryRoleTemplatesDirectoryRoleTemplatesService)RestProxy.create(DirectoryRoleTemplatesDirectoryRoleTemplatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listDirectoryRoleTemplateSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDirectoryRoleTemplate(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).value(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listDirectoryRoleTemplateSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDirectoryRoleTemplate(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).value(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listDirectoryRoleTemplateSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDirectoryRoleTemplateSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplateAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listDirectoryRoleTemplateSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplate() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby = null;
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listDirectoryRoleTemplateAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryRoleTemplateInner> listDirectoryRoleTemplate(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryRoleTemplatesDirectoryRoleTemplateOrderby> orderby, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listDirectoryRoleTemplateAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplateWithResponseAsync(MicrosoftGraphDirectoryRoleTemplateInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDirectoryRoleTemplate(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplateWithResponseAsync(MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDirectoryRoleTemplate(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryRoleTemplateInner> createDirectoryRoleTemplateAsync(MicrosoftGraphDirectoryRoleTemplateInner body) {
        return this.createDirectoryRoleTemplateWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryRoleTemplateInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryRoleTemplateInner createDirectoryRoleTemplate(MicrosoftGraphDirectoryRoleTemplateInner body) {
        return (MicrosoftGraphDirectoryRoleTemplateInner)this.createDirectoryRoleTemplateAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryRoleTemplateInner> createDirectoryRoleTemplateWithResponse(MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        return (Response)this.createDirectoryRoleTemplateWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateAsync(String directoryRoleTemplateId, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand) {
        return this.getDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryRoleTemplateInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateAsync(String directoryRoleTemplateId) {
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        List<String> expand = null;
        return this.getDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryRoleTemplateInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryRoleTemplateInner getDirectoryRoleTemplate(String directoryRoleTemplateId) {
        List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryRoleTemplateInner)this.getDirectoryRoleTemplateAsync(directoryRoleTemplateId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryRoleTemplateInner> getDirectoryRoleTemplateWithResponse(String directoryRoleTemplateId, List<DirectoryRoleTemplatesDirectoryRoleTemplateSelect> select, List<String> expand, Context context) {
        return (Response)this.getDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateDirectoryRoleTemplateAsync(String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body) {
        return this.updateDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateDirectoryRoleTemplate(String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body) {
        this.updateDirectoryRoleTemplateAsync(directoryRoleTemplateId, body).block();
    }

    @Override
    public Response<Void> updateDirectoryRoleTemplateWithResponse(String directoryRoleTemplateId, MicrosoftGraphDirectoryRoleTemplateInner body, Context context) {
        return (Response)this.updateDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteDirectoryRoleTemplateWithResponseAsync(String directoryRoleTemplateId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDirectoryRoleTemplate(this.client.getEndpoint(), directoryRoleTemplateId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteDirectoryRoleTemplateAsync(String directoryRoleTemplateId, String ifMatch) {
        return this.deleteDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteDirectoryRoleTemplateAsync(String directoryRoleTemplateId) {
        String ifMatch = null;
        return this.deleteDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteDirectoryRoleTemplate(String directoryRoleTemplateId) {
        String ifMatch = null;
        this.deleteDirectoryRoleTemplateAsync(directoryRoleTemplateId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteDirectoryRoleTemplateWithResponse(String directoryRoleTemplateId, String ifMatch, Context context) {
        return (Response)this.deleteDirectoryRoleTemplateWithResponseAsync(directoryRoleTemplateId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).value(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryRoleTemplateInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).value(), ((CollectionOfDirectoryRoleTemplate)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DirectoryRoleTemplatesDirectoryRoleTemplatesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoleTemplates")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryRoleTemplate>> listDirectoryRoleTemplate(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> createDirectoryRoleTemplate(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphDirectoryRoleTemplateInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directoryRoleTemplates/{directoryRoleTemplate-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryRoleTemplateInner>> getDirectoryRoleTemplate(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directoryRoleTemplates/{directoryRoleTemplate-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateDirectoryRoleTemplate(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDirectoryRoleTemplateInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directoryRoleTemplates/{directoryRoleTemplate-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteDirectoryRoleTemplate(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryRoleTemplate>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

