/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryRoleTemplatesClient;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRoleTemplatesValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DirectoryRoleTemplatesClientImpl
implements DirectoryRoleTemplatesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryRoleTemplatesClientImpl.class);
    private final DirectoryRoleTemplatesService service;
    private final MicrosoftGraphClientImpl client;

    DirectoryRoleTemplatesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DirectoryRoleTemplatesService)RestProxy.create(DirectoryRoleTemplatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> checkMemberGroupsAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(directoryRoleTemplateId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> checkMemberGroups(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(directoryRoleTemplateId, body).block();
    }

    @Override
    public Response<List<String>> checkMemberGroupsWithResponse(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(directoryRoleTemplateId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> checkMemberObjectsAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(directoryRoleTemplateId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> checkMemberObjects(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(directoryRoleTemplateId, body).block();
    }

    @Override
    public Response<List<String>> checkMemberObjectsWithResponse(String directoryRoleTemplateId, DirectoryRoleTemplatesCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(directoryRoleTemplateId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> getMemberGroupsAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(directoryRoleTemplateId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> getMemberGroups(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(directoryRoleTemplateId, body).block();
    }

    @Override
    public Response<List<String>> getMemberGroupsWithResponse(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(directoryRoleTemplateId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), directoryRoleTemplateId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> getMemberObjectsAsync(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(directoryRoleTemplateId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> getMemberObjects(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(directoryRoleTemplateId, body).block();
    }

    @Override
    public Response<List<String>> getMemberObjectsWithResponse(String directoryRoleTemplateId, DirectoryRoleTemplatesGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(directoryRoleTemplateId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String directoryRoleTemplateId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), directoryRoleTemplateId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String directoryRoleTemplateId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryRoleTemplateId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryRoleTemplateId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), directoryRoleTemplateId, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String directoryRoleTemplateId) {
        return this.restoreWithResponseAsync(directoryRoleTemplateId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner restore(String directoryRoleTemplateId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(directoryRoleTemplateId).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String directoryRoleTemplateId, Context context) {
        return (Response)this.restoreWithResponseAsync(directoryRoleTemplateId, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(DirectoryRoleTemplatesGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(DirectoryRoleTemplatesGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(DirectoryRoleTemplatesGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(DirectoryRoleTemplatesGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(DirectoryRoleTemplatesGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(DirectoryRoleTemplatesValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> validatePropertiesWithResponseAsync(DirectoryRoleTemplatesValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<Void> validatePropertiesAsync(DirectoryRoleTemplatesValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    public void validateProperties(DirectoryRoleTemplatesValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    public Response<Void> validatePropertiesWithResponse(DirectoryRoleTemplatesValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DirectoryRoleTemplatesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/{directoryRoleTemplate-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @BodyParam(value="application/json") DirectoryRoleTemplatesCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/{directoryRoleTemplate-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @BodyParam(value="application/json") DirectoryRoleTemplatesCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/{directoryRoleTemplate-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @BodyParam(value="application/json") DirectoryRoleTemplatesGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/{directoryRoleTemplate-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @BodyParam(value="application/json") DirectoryRoleTemplatesGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/{directoryRoleTemplate-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="directoryRoleTemplate-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DirectoryRoleTemplatesGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DirectoryRoleTemplatesGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directoryRoleTemplates/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") DirectoryRoleTemplatesValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

