/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.SignedInUsersClient;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.DirectoryObjectListResult;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import reactor.core.publisher.Mono;

public final class SignedInUsersClientImpl
implements SignedInUsersClient {
    private final ClientLogger logger = new ClientLogger(SignedInUsersClientImpl.class);
    private final SignedInUsersService service;
    private final GraphRbacManagementClientImpl client;

    SignedInUsersClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (SignedInUsersService)RestProxy.create(SignedInUsersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<UserInner>> getWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<UserInner>> getWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<UserInner> getAsync() {
        return this.getWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((UserInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public UserInner get() {
        return (UserInner)this.getAsync().block();
    }

    @Override
    public Response<UserInner> getWithResponse(Context context) {
        return (Response)this.getWithResponseAsync(context).block();
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnedObjectsSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnedObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnedObjectsSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnedObjects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<DirectoryObjectInner> listOwnedObjectsAsync() {
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<DirectoryObjectInner> listOwnedObjectsAsync(Context context) {
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(context), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwnedObjects() {
        return new PagedIterable(this.listOwnedObjectsAsync());
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwnedObjects(Context context) {
        return new PagedIterable(this.listOwnedObjectsAsync(context));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnedObjectsNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnedObjectsNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnedObjectsNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface SignedInUsersService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/me")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<UserInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, Context var4);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/me/ownedObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwnedObjects(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, Context var4);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwnedObjectsNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);
    }
}

