/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.DirectoryObjectListResult;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.authorization.models.KeyCredentialListResult;
import com.azure.resourcemanager.authorization.models.KeyCredentialsUpdateParameters;
import com.azure.resourcemanager.authorization.models.PasswordCredentialListResult;
import com.azure.resourcemanager.authorization.models.PasswordCredentialsUpdateParameters;
import com.azure.resourcemanager.authorization.models.ServicePrincipalBase;
import com.azure.resourcemanager.authorization.models.ServicePrincipalCreateParameters;
import com.azure.resourcemanager.authorization.models.ServicePrincipalListResult;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ServicePrincipalsClientImpl
implements ServicePrincipalsClient {
    private final ClientLogger logger = new ClientLogger(ServicePrincipalsClientImpl.class);
    private final ServicePrincipalsService service;
    private final GraphRbacManagementClientImpl client;

    ServicePrincipalsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (ServicePrincipalsService)RestProxy.create(ServicePrincipalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ServicePrincipalInner>> createWithResponseAsync(ServicePrincipalCreateParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ServicePrincipalInner>> createWithResponseAsync(ServicePrincipalCreateParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<ServicePrincipalInner> createAsync(ServicePrincipalCreateParameters parameters) {
        return this.createWithResponseAsync(parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ServicePrincipalInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ServicePrincipalInner create(ServicePrincipalCreateParameters parameters) {
        return (ServicePrincipalInner)this.createAsync(parameters).block();
    }

    @Override
    public Response<ServicePrincipalInner> createWithResponse(ServicePrincipalCreateParameters parameters, Context context) {
        return (Response)this.createWithResponseAsync(parameters, context).block();
    }

    private Mono<PagedResponse<ServicePrincipalInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServicePrincipalListResult)res.getValue()).value(), ((ServicePrincipalListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ServicePrincipalInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServicePrincipalListResult)res.getValue()).value(), ((ServicePrincipalListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<ServicePrincipalInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<ServicePrincipalInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<ServicePrincipalInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<ServicePrincipalInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @Override
    public PagedIterable<ServicePrincipalInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    public Mono<Response<Void>> updateWithResponseAsync(String objectId, ServicePrincipalBase parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateWithResponseAsync(String objectId, ServicePrincipalBase parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> updateAsync(String objectId, ServicePrincipalBase parameters) {
        return this.updateWithResponseAsync(objectId, parameters).flatMap(res -> Mono.empty());
    }

    @Override
    public void update(String objectId, ServicePrincipalBase parameters) {
        this.updateAsync(objectId, parameters).block();
    }

    @Override
    public Response<Void> updateWithResponse(String objectId, ServicePrincipalBase parameters, Context context) {
        return (Response)this.updateWithResponseAsync(objectId, parameters, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<Void> deleteAsync(String objectId) {
        return this.deleteWithResponseAsync(objectId).flatMap(res -> Mono.empty());
    }

    @Override
    public void delete(String objectId) {
        this.deleteAsync(objectId).block();
    }

    @Override
    public Response<Void> deleteWithResponse(String objectId, Context context) {
        return (Response)this.deleteWithResponseAsync(objectId, context).block();
    }

    @Override
    public Mono<Response<ServicePrincipalInner>> getWithResponseAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ServicePrincipalInner>> getWithResponseAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<ServicePrincipalInner> getAsync(String objectId) {
        return this.getWithResponseAsync(objectId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ServicePrincipalInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ServicePrincipalInner get(String objectId) {
        return (ServicePrincipalInner)this.getAsync(objectId).block();
    }

    @Override
    public Response<ServicePrincipalInner> getWithResponse(String objectId, Context context) {
        return (Response)this.getWithResponseAsync(objectId, context).block();
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwners(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersSinglePageAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwners(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(objectId), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<DirectoryObjectInner> listOwnersAsync(String objectId, Context context) {
        return new PagedFlux(() -> this.listOwnersSinglePageAsync(objectId, context), nextLink -> this.listOwnersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwners(String objectId) {
        return new PagedIterable(this.listOwnersAsync(objectId));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> listOwners(String objectId, Context context) {
        return new PagedIterable(this.listOwnersAsync(objectId, context));
    }

    private Mono<PagedResponse<KeyCredentialInner>> listKeyCredentialsSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listKeyCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyCredentialListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<KeyCredentialInner>> listKeyCredentialsSinglePageAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listKeyCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyCredentialListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String objectId) {
        return new PagedFlux(() -> this.listKeyCredentialsSinglePageAsync(objectId));
    }

    private PagedFlux<KeyCredentialInner> listKeyCredentialsAsync(String objectId, Context context) {
        return new PagedFlux(() -> this.listKeyCredentialsSinglePageAsync(objectId, context));
    }

    @Override
    public PagedIterable<KeyCredentialInner> listKeyCredentials(String objectId) {
        return new PagedIterable(this.listKeyCredentialsAsync(objectId));
    }

    @Override
    public PagedIterable<KeyCredentialInner> listKeyCredentials(String objectId, Context context) {
        return new PagedIterable(this.listKeyCredentialsAsync(objectId, context));
    }

    @Override
    public Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(String objectId, List<KeyCredentialInner> value) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        return FluxUtil.withContext(context -> this.service.updateKeyCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateKeyCredentialsWithResponseAsync(String objectId, List<KeyCredentialInner> value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        KeyCredentialsUpdateParameters parameters = new KeyCredentialsUpdateParameters();
        parameters.withValue(value);
        context = this.client.mergeContext(context);
        return this.service.updateKeyCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> updateKeyCredentialsAsync(String objectId, List<KeyCredentialInner> value) {
        return this.updateKeyCredentialsWithResponseAsync(objectId, value).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateKeyCredentials(String objectId, List<KeyCredentialInner> value) {
        this.updateKeyCredentialsAsync(objectId, value).block();
    }

    @Override
    public Response<Void> updateKeyCredentialsWithResponse(String objectId, List<KeyCredentialInner> value, Context context) {
        return (Response)this.updateKeyCredentialsWithResponseAsync(objectId, value, context).block();
    }

    private Mono<PagedResponse<PasswordCredentialInner>> listPasswordCredentialsSinglePageAsync(String objectId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listPasswordCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PasswordCredentialListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<PasswordCredentialInner>> listPasswordCredentialsSinglePageAsync(String objectId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listPasswordCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PasswordCredentialListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String objectId) {
        return new PagedFlux(() -> this.listPasswordCredentialsSinglePageAsync(objectId));
    }

    private PagedFlux<PasswordCredentialInner> listPasswordCredentialsAsync(String objectId, Context context) {
        return new PagedFlux(() -> this.listPasswordCredentialsSinglePageAsync(objectId, context));
    }

    @Override
    public PagedIterable<PasswordCredentialInner> listPasswordCredentials(String objectId) {
        return new PagedIterable(this.listPasswordCredentialsAsync(objectId));
    }

    @Override
    public PagedIterable<PasswordCredentialInner> listPasswordCredentials(String objectId, Context context) {
        return new PagedIterable(this.listPasswordCredentialsAsync(objectId, context));
    }

    @Override
    public Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(String objectId, List<PasswordCredentialInner> value) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        return FluxUtil.withContext(context -> this.service.updatePasswordCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updatePasswordCredentialsWithResponseAsync(String objectId, List<PasswordCredentialInner> value, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (objectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter objectId is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (value == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter value is required and cannot be null."));
        }
        value.forEach(e -> e.validate());
        PasswordCredentialsUpdateParameters parameters = new PasswordCredentialsUpdateParameters();
        parameters.withValue(value);
        context = this.client.mergeContext(context);
        return this.service.updatePasswordCredentials(this.client.getEndpoint(), objectId, this.client.getApiVersion(), this.client.getTenantId(), parameters, context);
    }

    @Override
    public Mono<Void> updatePasswordCredentialsAsync(String objectId, List<PasswordCredentialInner> value) {
        return this.updatePasswordCredentialsWithResponseAsync(objectId, value).flatMap(res -> Mono.empty());
    }

    @Override
    public void updatePasswordCredentials(String objectId, List<PasswordCredentialInner> value) {
        this.updatePasswordCredentialsAsync(objectId, value).block();
    }

    @Override
    public Response<Void> updatePasswordCredentialsWithResponse(String objectId, List<PasswordCredentialInner> value, Context context) {
        return (Response)this.updatePasswordCredentialsWithResponseAsync(objectId, value, context).block();
    }

    private Mono<PagedResponse<ServicePrincipalInner>> listNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServicePrincipalListResult)res.getValue()).value(), ((ServicePrincipalListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<ServicePrincipalInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ServicePrincipalListResult)res.getValue()).value(), ((ServicePrincipalListResult)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> listOwnersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface ServicePrincipalsService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/servicePrincipals")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ServicePrincipalInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") ServicePrincipalCreateParameters var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/servicePrincipals")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ServicePrincipalListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/servicePrincipals/{objectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> update(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") ServicePrincipalBase var5, Context var6);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/{tenantID}/servicePrincipals/{objectId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/servicePrincipals/{objectId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ServicePrincipalInner>> get(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/servicePrincipals/{objectId}/owners")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwners(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<KeyCredentialListResult>> listKeyCredentials(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/servicePrincipals/{objectId}/keyCredentials")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> updateKeyCredentials(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") KeyCredentialsUpdateParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<PasswordCredentialListResult>> listPasswordCredentials(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Patch(value="/{tenantID}/servicePrincipals/{objectId}/passwordCredentials")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<Void>> updatePasswordCredentials(@HostParam(value="$host") String var1, @PathParam(value="objectId") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, @BodyParam(value="application/json") PasswordCredentialsUpdateParameters var5, Context var6);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<ServicePrincipalListResult>> listNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=GraphErrorException.class)
        public Mono<Response<DirectoryObjectListResult>> listOwnersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

