/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ObjectsClient;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryObjectInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.DirectoryObjectListResult;
import com.azure.resourcemanager.authorization.models.GetObjectsParameters;
import reactor.core.publisher.Mono;

public final class ObjectsClientImpl
implements ObjectsClient {
    private final ClientLogger logger = new ClientLogger(ObjectsClientImpl.class);
    private final ObjectsService service;
    private final GraphRbacManagementClientImpl client;

    ObjectsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (ObjectsService)RestProxy.create(ObjectsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getObjectsByObjectIdsSinglePageAsync(GetObjectsParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.getObjectsByObjectIds(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getObjectsByObjectIdsSinglePageAsync(GetObjectsParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        context = this.client.mergeContext(context);
        return this.service.getObjectsByObjectIds(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getTenantId(), parameters, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<DirectoryObjectInner> getObjectsByObjectIdsAsync(GetObjectsParameters parameters) {
        return new PagedFlux(() -> this.getObjectsByObjectIdsSinglePageAsync(parameters), nextLink -> this.getObjectsByObjectIdsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<DirectoryObjectInner> getObjectsByObjectIdsAsync(GetObjectsParameters parameters, Context context) {
        return new PagedFlux(() -> this.getObjectsByObjectIdsSinglePageAsync(parameters, context), nextLink -> this.getObjectsByObjectIdsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> getObjectsByObjectIds(GetObjectsParameters parameters) {
        return new PagedIterable(this.getObjectsByObjectIdsAsync(parameters));
    }

    @Override
    public PagedIterable<DirectoryObjectInner> getObjectsByObjectIds(GetObjectsParameters parameters, Context context) {
        return new PagedIterable(this.getObjectsByObjectIdsAsync(parameters, context));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getObjectsByObjectIdsNextSinglePageAsync(String nextLink) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getObjectsByObjectIdsNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DirectoryObjectInner>> getObjectsByObjectIdsNextSinglePageAsync(String nextLink, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.getObjectsByObjectIdsNext(this.client.getEndpoint(), nextLink, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DirectoryObjectListResult)res.getValue()).value(), ((DirectoryObjectListResult)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface ObjectsService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/getObjectsByObjectIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DirectoryObjectListResult>> getObjectsByObjectIds(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="tenantID") String var3, @BodyParam(value="application/json") GetObjectsParameters var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Post(value="/{tenantID}/{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DirectoryObjectListResult>> getObjectsByObjectIdsNext(@HostParam(value="$host") String var1, @PathParam(value="nextLink", encoded=true) String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);
    }
}

