/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DomainsClient;
import com.azure.resourcemanager.authorization.fluent.models.DomainInner;
import com.azure.resourcemanager.authorization.implementation.GraphRbacManagementClientImpl;
import com.azure.resourcemanager.authorization.models.DomainListResult;
import reactor.core.publisher.Mono;

public final class DomainsClientImpl
implements DomainsClient {
    private final ClientLogger logger = new ClientLogger(DomainsClientImpl.class);
    private final DomainsService service;
    private final GraphRbacManagementClientImpl client;

    DomainsClientImpl(GraphRbacManagementClientImpl client) {
        this.service = (DomainsService)RestProxy.create(DomainsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<DomainInner>> listSinglePageAsync(String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DomainListResult)res.getValue()).value(), null, null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<DomainInner>> listSinglePageAsync(String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), filter, this.client.getApiVersion(), this.client.getTenantId(), context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DomainListResult)res.getValue()).value(), null, null));
    }

    @Override
    public PagedFlux<DomainInner> listAsync(String filter) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter));
    }

    @Override
    public PagedFlux<DomainInner> listAsync() {
        String filter = null;
        return new PagedFlux(() -> this.listSinglePageAsync(filter));
    }

    private PagedFlux<DomainInner> listAsync(String filter, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(filter, context));
    }

    @Override
    public PagedIterable<DomainInner> list(String filter, Context context) {
        return new PagedIterable(this.listAsync(filter, context));
    }

    @Override
    public PagedIterable<DomainInner> list() {
        String filter = null;
        return new PagedIterable(this.listAsync(filter));
    }

    @Override
    public Mono<Response<DomainInner>> getWithResponseAsync(String domainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), domainName, this.client.getApiVersion(), this.client.getTenantId(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<DomainInner>> getWithResponseAsync(String domainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (domainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainName is required and cannot be null."));
        }
        if (this.client.getTenantId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getTenantId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), domainName, this.client.getApiVersion(), this.client.getTenantId(), context);
    }

    @Override
    public Mono<DomainInner> getAsync(String domainName) {
        return this.getWithResponseAsync(domainName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DomainInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public DomainInner get(String domainName) {
        return (DomainInner)this.getAsync(domainName).block();
    }

    @Override
    public Response<DomainInner> getWithResponse(String domainName, Context context) {
        return (Response)this.getWithResponseAsync(domainName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="GraphRbacManagementC")
    private static interface DomainsService {
        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/domains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DomainListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="$filter") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);

        @Headers(value={"Accept: application/json,text/json", "Content-Type: application/json"})
        @Get(value="/{tenantID}/domains/{domainName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DomainInner>> get(@HostParam(value="$host") String var1, @PathParam(value="domainName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="tenantID") String var4, Context var5);
    }
}

