/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.UsersClient;
import com.azure.resourcemanager.authorization.fluent.models.UserInner;
import com.azure.resourcemanager.authorization.implementation.ActiveDirectoryUserImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUsers;
import com.azure.resourcemanager.authorization.models.GraphErrorException;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import reactor.core.publisher.Mono;

public class ActiveDirectoryUsersImpl
extends CreatableWrappersImpl<ActiveDirectoryUser, ActiveDirectoryUserImpl, UserInner>
implements ActiveDirectoryUsers {
    private final AuthorizationManager manager;

    public ActiveDirectoryUsersImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    public PagedIterable<ActiveDirectoryUser> list() {
        return this.wrapList(this.manager().serviceClient().getUsers().list());
    }

    protected ActiveDirectoryUserImpl wrapModel(UserInner userInner) {
        if (userInner == null) {
            return null;
        }
        return new ActiveDirectoryUserImpl(userInner, this.manager());
    }

    public ActiveDirectoryUserImpl getById(String objectId) {
        return (ActiveDirectoryUserImpl)this.getByIdAsync(objectId).block();
    }

    public Mono<ActiveDirectoryUser> getByIdAsync(String id) {
        return this.manager().serviceClient().getUsers().getAsync(id).map(userInner -> new ActiveDirectoryUserImpl((UserInner)userInner, this.manager()));
    }

    public ActiveDirectoryUserImpl getByName(String upn) {
        return (ActiveDirectoryUserImpl)this.getByNameAsync(upn).block();
    }

    public Mono<ActiveDirectoryUser> getByNameAsync(String name) {
        return this.manager().serviceClient().getUsers().getAsync(name).onErrorResume(GraphErrorException.class, e -> {
            if (name.contains("@")) {
                return this.manager().serviceClient().getUsers().listAsync(String.format("mail eq '%s' or mailNickName eq '%s#EXT#'", name, name.replace("@", "_")), null).singleOrEmpty();
            }
            return this.manager().serviceClient().getUsers().listAsync(String.format("displayName eq '%s'", name), null).singleOrEmpty();
        }).map(userInner -> new ActiveDirectoryUserImpl((UserInner)userInner, this.manager()));
    }

    public PagedFlux<ActiveDirectoryUser> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    public ActiveDirectoryUserImpl define(String name) {
        return this.wrapModel(name);
    }

    protected ActiveDirectoryUserImpl wrapModel(String name) {
        return new ActiveDirectoryUserImpl(new UserInner().withDisplayName(name), this.manager());
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.manager().serviceClient().getUsers().deleteAsync(id);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public UsersClient inner() {
        return this.manager().serviceClient().getUsers();
    }

    public PagedIterable<ActiveDirectoryUser> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ActiveDirectoryUser> listByFilterAsync(String filter) {
        return this.inner().listAsync(filter, null).mapPage(this::wrapModel);
    }
}

