/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.ApplicationInner;
import com.azure.resourcemanager.authorization.fluent.models.KeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.PasswordCredentialInner;
import com.azure.resourcemanager.authorization.implementation.CertificateCredentialImpl;
import com.azure.resourcemanager.authorization.implementation.HasCredential;
import com.azure.resourcemanager.authorization.implementation.PasswordCredentialImpl;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.azure.resourcemanager.authorization.models.ApplicationCreateParameters;
import com.azure.resourcemanager.authorization.models.ApplicationUpdateParameters;
import com.azure.resourcemanager.authorization.models.CertificateCredential;
import com.azure.resourcemanager.authorization.models.PasswordCredential;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class ActiveDirectoryApplicationImpl
extends CreatableUpdatableImpl<ActiveDirectoryApplication, ApplicationInner, ActiveDirectoryApplicationImpl>
implements ActiveDirectoryApplication,
ActiveDirectoryApplication.Definition,
ActiveDirectoryApplication.Update,
HasCredential<ActiveDirectoryApplicationImpl> {
    private AuthorizationManager manager;
    private ApplicationCreateParameters createParameters;
    private ApplicationUpdateParameters updateParameters;
    private Map<String, PasswordCredential> cachedPasswordCredentials;
    private Map<String, CertificateCredential> cachedCertificateCredentials;

    ActiveDirectoryApplicationImpl(ApplicationInner innerObject, AuthorizationManager manager) {
        super(innerObject.displayName(), (Object)innerObject);
        this.manager = manager;
        this.createParameters = new ApplicationCreateParameters().withDisplayName(innerObject.displayName());
        this.updateParameters = new ApplicationUpdateParameters().withDisplayName(innerObject.displayName());
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Mono<ActiveDirectoryApplication> createResourceAsync() {
        if (this.createParameters.identifierUris() == null) {
            this.createParameters.withIdentifierUris(new ArrayList<String>());
            this.createParameters.identifierUris().add(this.createParameters.homepage());
        }
        return this.manager.serviceClient().getApplications().createAsync(this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap(application -> this.refreshCredentialsAsync());
    }

    public Mono<ActiveDirectoryApplication> updateResourceAsync() {
        return this.manager.serviceClient().getApplications().patchAsync(this.id(), this.updateParameters).then(Mono.just((Object)this));
    }

    Mono<ActiveDirectoryApplication> refreshCredentialsAsync() {
        Mono keyCredentials = this.manager.serviceClient().getApplications().listKeyCredentialsAsync(this.id()).map(keyCredentialInner -> new CertificateCredentialImpl((KeyCredentialInner)keyCredentialInner)).collectMap(certificateCredential -> certificateCredential.name()).map(stringCertificateCredentialMap -> {
            this.cachedCertificateCredentials = stringCertificateCredentialMap;
            return this;
        });
        Mono passwordCredentials = this.manager.serviceClient().getApplications().listPasswordCredentialsAsync(this.id()).map(passwordCredentialInner -> new PasswordCredentialImpl((PasswordCredentialInner)passwordCredentialInner)).collectMap(passwordCredential -> passwordCredential.name()).map(stringPasswordCredentialMap -> {
            this.cachedPasswordCredentials = stringPasswordCredentialMap;
            return this;
        });
        return keyCredentials.mergeWith((Publisher)passwordCredentials).last();
    }

    public Mono<ActiveDirectoryApplication> refreshAsync() {
        return this.getInnerAsync().map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this)).flatMap(application -> this.refreshCredentialsAsync());
    }

    @Override
    public String applicationId() {
        return ((ApplicationInner)this.innerModel()).appId();
    }

    @Override
    public List<String> applicationPermissions() {
        if (((ApplicationInner)this.innerModel()).appPermissions() == null) {
            return null;
        }
        return Collections.unmodifiableList(((ApplicationInner)this.innerModel()).appPermissions());
    }

    @Override
    public boolean availableToOtherTenants() {
        return ((ApplicationInner)this.innerModel()).availableToOtherTenants();
    }

    @Override
    public Set<String> identifierUris() {
        if (((ApplicationInner)this.innerModel()).identifierUris() == null) {
            return null;
        }
        return Collections.unmodifiableSet(new HashSet<String>(((ApplicationInner)this.innerModel()).identifierUris()));
    }

    @Override
    public Set<String> replyUrls() {
        if (((ApplicationInner)this.innerModel()).replyUrls() == null) {
            return null;
        }
        return Collections.unmodifiableSet(new HashSet<String>(((ApplicationInner)this.innerModel()).replyUrls()));
    }

    @Override
    public URL signOnUrl() {
        try {
            return new URL(((ApplicationInner)this.innerModel()).homepage());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Map<String, PasswordCredential> passwordCredentials() {
        if (this.cachedPasswordCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedPasswordCredentials);
    }

    @Override
    public Map<String, CertificateCredential> certificateCredentials() {
        if (this.cachedCertificateCredentials == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.cachedCertificateCredentials);
    }

    protected Mono<ApplicationInner> getInnerAsync() {
        return this.manager.serviceClient().getApplications().getAsync(this.id());
    }

    @Override
    public ActiveDirectoryApplicationImpl withSignOnUrl(String signOnUrl) {
        if (this.isInCreateMode()) {
            this.createParameters.withHomepage(signOnUrl);
        } else {
            this.updateParameters.withHomepage(signOnUrl);
        }
        return this.withReplyUrl(signOnUrl);
    }

    @Override
    public ActiveDirectoryApplicationImpl withReplyUrl(String replyUrl) {
        if (this.isInCreateMode()) {
            if (this.createParameters.replyUrls() == null) {
                this.createParameters.withReplyUrls(new ArrayList<String>());
            }
            this.createParameters.replyUrls().add(replyUrl);
        } else {
            if (this.updateParameters.replyUrls() == null) {
                this.updateParameters.withReplyUrls(new ArrayList<String>(this.replyUrls()));
            }
            this.updateParameters.replyUrls().add(replyUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withoutReplyUrl(String replyUrl) {
        if (this.updateParameters.replyUrls() != null) {
            this.updateParameters.replyUrls().remove(replyUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withIdentifierUrl(String identifierUrl) {
        if (this.isInCreateMode()) {
            if (this.createParameters.identifierUris() == null) {
                this.createParameters.withIdentifierUris(new ArrayList<String>());
            }
            this.createParameters.identifierUris().add(identifierUrl);
        } else {
            if (this.updateParameters.identifierUris() == null) {
                this.updateParameters.withIdentifierUris(new ArrayList<String>(this.identifierUris()));
            }
            this.updateParameters.identifierUris().add(identifierUrl);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplication.Update withoutIdentifierUrl(String identifierUrl) {
        if (this.updateParameters.identifierUris() != null) {
            this.updateParameters.identifierUris().remove(identifierUrl);
        }
        return this;
    }

    public CertificateCredentialImpl<ActiveDirectoryApplicationImpl> defineCertificateCredential(String name) {
        return new CertificateCredentialImpl<ActiveDirectoryApplicationImpl>(name, this);
    }

    public PasswordCredentialImpl<ActiveDirectoryApplicationImpl> definePasswordCredential(String name) {
        return new PasswordCredentialImpl<ActiveDirectoryApplicationImpl>(name, this);
    }

    @Override
    public ActiveDirectoryApplicationImpl withoutCredential(String name) {
        if (this.cachedPasswordCredentials.containsKey(name)) {
            this.cachedPasswordCredentials.remove(name);
            ArrayList<PasswordCredentialInner> updatePasswordCredentials = new ArrayList<PasswordCredentialInner>();
            for (PasswordCredential passwordCredential : this.cachedPasswordCredentials.values()) {
                updatePasswordCredentials.add((PasswordCredentialInner)passwordCredential.innerModel());
            }
            this.updateParameters.withPasswordCredentials(updatePasswordCredentials);
        } else if (this.cachedCertificateCredentials.containsKey(name)) {
            this.cachedCertificateCredentials.remove(name);
            ArrayList<KeyCredentialInner> updateCertificateCredentials = new ArrayList<KeyCredentialInner>();
            for (CertificateCredential certificateCredential : this.cachedCertificateCredentials.values()) {
                updateCertificateCredentials.add((KeyCredentialInner)certificateCredential.innerModel());
            }
            this.updateParameters.withKeyCredentials(updateCertificateCredentials);
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withCertificateCredential(CertificateCredentialImpl<?> credential) {
        if (this.isInCreateMode()) {
            if (this.createParameters.keyCredentials() == null) {
                this.createParameters.withKeyCredentials(new ArrayList<KeyCredentialInner>());
            }
            this.createParameters.keyCredentials().add((KeyCredentialInner)credential.innerModel());
        } else {
            if (this.updateParameters.keyCredentials() == null) {
                this.updateParameters.withKeyCredentials(new ArrayList<KeyCredentialInner>());
            }
            this.updateParameters.keyCredentials().add((KeyCredentialInner)credential.innerModel());
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withPasswordCredential(PasswordCredentialImpl<?> credential) {
        if (this.isInCreateMode()) {
            if (this.createParameters.passwordCredentials() == null) {
                this.createParameters.withPasswordCredentials(new ArrayList<PasswordCredentialInner>());
            }
            this.createParameters.passwordCredentials().add((PasswordCredentialInner)credential.innerModel());
        } else {
            if (this.updateParameters.passwordCredentials() == null) {
                this.updateParameters.withPasswordCredentials(new ArrayList<PasswordCredentialInner>());
            }
            this.updateParameters.passwordCredentials().add((PasswordCredentialInner)credential.innerModel());
        }
        return this;
    }

    @Override
    public ActiveDirectoryApplicationImpl withAvailableToOtherTenants(boolean availableToOtherTenants) {
        if (this.isInCreateMode()) {
            this.createParameters.withAvailableToOtherTenants(availableToOtherTenants);
        } else {
            this.updateParameters.withAvailableToOtherTenants(availableToOtherTenants);
        }
        return this;
    }

    public String id() {
        return ((ApplicationInner)this.innerModel()).objectId();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

