/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.util;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.sas.QueueSasPermission;
import com.azure.storage.queue.sas.QueueServiceSasSignatureValues;
import java.time.OffsetDateTime;
import java.util.Objects;

public class QueueSasImplUtil {
    private final ClientLogger logger = new ClientLogger(QueueSasImplUtil.class);
    private String version;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String queueName;
    private String identifier;

    public QueueSasImplUtil(QueueServiceSasSignatureValues sasValues, String queueName) {
        Objects.requireNonNull(sasValues);
        this.version = sasValues.getVersion();
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.queueName = queueName;
        this.identifier = sasValues.getIdentifier();
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials) {
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String stringToSign = this.stringToSign(canonicalName);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return this.encode(signature);
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sv", (Object)this.version);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"st", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)this.startTime));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"se", (Object)SasImplUtils.formatQueryParameterDate((OffsetDateTime)this.expiryTime));
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sip", (Object)this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"si", (Object)this.identifier);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sp", (Object)this.permissions);
        SasImplUtils.tryAppendQueryParameter((StringBuilder)sb, (String)"sig", (Object)signature);
        return sb.toString();
    }

    private void ensureState() {
        if (this.version == null) {
            this.version = QueueServiceVersion.getLatest().getVersion();
        }
        if (this.identifier == null && (this.expiryTime == null || this.permissions == null)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("If identifier is not set, expiry time and permissions must be set"));
        }
        if (this.permissions != null) {
            if (this.queueName != null) {
                this.permissions = QueueSasPermission.parse(this.permissions).toString();
            } else {
                this.logger.info("Not re-parsing permissions. Resource type is not queue.");
            }
        }
    }

    private String getCanonicalName(String account) {
        return String.join((CharSequence)"", "/queue/", account, "/", this.queueName);
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version == null ? "" : this.version);
    }
}

