/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.SignedIdentifiersWrapper;
import com.azure.storage.queue.implementation.models.QueuesCreateResponse;
import com.azure.storage.queue.implementation.models.QueuesDeleteResponse;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyResponse;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesResponse;
import com.azure.storage.queue.implementation.models.QueuesSetAccessPolicyResponse;
import com.azure.storage.queue.implementation.models.QueuesSetMetadataResponse;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.QueueStorageException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class QueuesImpl {
    private QueuesService service;
    private AzureQueueStorageImpl client;

    public QueuesImpl(AzureQueueStorageImpl client) {
        this.service = (QueuesService)RestProxy.create(QueuesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<QueuesCreateResponse> createWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String requestId = null;
        return this.service.create(queueName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), requestId, context);
    }

    public Mono<QueuesCreateResponse> createWithRestResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        return this.service.create(queueName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), requestId, context);
    }

    public Mono<QueuesDeleteResponse> deleteWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.delete(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<QueuesDeleteResponse> deleteWithRestResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.service.delete(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<QueuesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "metadata";
        return this.service.getProperties(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, "metadata", context);
    }

    public Mono<QueuesGetPropertiesResponse> getPropertiesWithRestResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "metadata";
        return this.service.getProperties(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, "metadata", context);
    }

    public Mono<QueuesSetMetadataResponse> setMetadataWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String requestId = null;
        String comp = "metadata";
        return this.service.setMetadata(queueName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), requestId, "metadata", context);
    }

    public Mono<QueuesSetMetadataResponse> setMetadataWithRestResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String comp = "metadata";
        return this.service.setMetadata(queueName, this.client.getUrl(), timeout, metadata, this.client.getVersion(), requestId, "metadata", context);
    }

    public Mono<QueuesGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "acl";
        return this.service.getAccessPolicy(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, "acl", context);
    }

    public Mono<QueuesGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        return this.service.getAccessPolicy(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, "acl", context);
    }

    public Mono<QueuesSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "acl";
        SignedIdentifiersWrapper queueAclConverted = new SignedIdentifiersWrapper(null);
        return this.service.setAccessPolicy(queueName, this.client.getUrl(), queueAclConverted, timeout, this.client.getVersion(), requestId, "acl", context);
    }

    public Mono<QueuesSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(String queueName, List<QueueSignedIdentifier> queueAcl, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        SignedIdentifiersWrapper queueAclConverted = new SignedIdentifiersWrapper(queueAcl);
        return this.service.setAccessPolicy(queueName, this.client.getUrl(), queueAclConverted, timeout, this.client.getVersion(), requestId, "acl", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageQueues")
    private static interface QueuesService {
        @Put(value="{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesCreateResponse> create(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, Context var7);

        @Delete(value="{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesDeleteResponse> delete(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, Context var6);

        @Get(value="{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesGetPropertiesResponse> getProperties(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Put(value="{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesSetMetadataResponse> setMetadata(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Get(value="{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesGetAccessPolicyResponse> getAccessPolicy(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Put(value="{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<QueuesSetAccessPolicyResponse> setAccessPolicy(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, Context var8);
    }
}

