/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="QueueMessage")
public final class PeekedMessageItem {
    @JsonProperty(value="MessageId", required=true)
    private String messageId;
    @JsonProperty(value="InsertionTime", required=true)
    private DateTimeRfc1123 insertionTime;
    @JsonProperty(value="ExpirationTime", required=true)
    private DateTimeRfc1123 expirationTime;
    @JsonProperty(value="DequeueCount", required=true)
    private long dequeueCount;
    @JsonProperty(value="MessageText", required=true)
    private String messageText;

    public String getMessageId() {
        return this.messageId;
    }

    public PeekedMessageItem setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public OffsetDateTime getInsertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.getDateTime();
    }

    public PeekedMessageItem setInsertionTime(OffsetDateTime insertionTime) {
        this.insertionTime = insertionTime == null ? null : new DateTimeRfc1123(insertionTime);
        return this;
    }

    public OffsetDateTime getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.getDateTime();
    }

    public PeekedMessageItem setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime == null ? null : new DateTimeRfc1123(expirationTime);
        return this;
    }

    public long getDequeueCount() {
        return this.dequeueCount;
    }

    public PeekedMessageItem setDequeueCount(long dequeueCount) {
        this.dequeueCount = dequeueCount;
        return this;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public PeekedMessageItem setMessageText(String messageText) {
        this.messageText = messageText;
        return this;
    }
}

