/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.storage.queue.models.QueueItem;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ListQueuesSegmentResponse
implements XmlSerializable<ListQueuesSegmentResponse> {
    private String serviceEndpoint;
    private String prefix;
    private String marker;
    private int maxResults;
    private List<QueueItem> queueItems;
    private String nextMarker;

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public ListQueuesSegmentResponse setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ListQueuesSegmentResponse setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public ListQueuesSegmentResponse setMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public ListQueuesSegmentResponse setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<QueueItem> getQueueItems() {
        if (this.queueItems == null) {
            this.queueItems = new ArrayList<QueueItem>();
        }
        return this.queueItems;
    }

    public ListQueuesSegmentResponse setQueueItems(List<QueueItem> queueItems) {
        this.queueItems = queueItems;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListQueuesSegmentResponse setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "EnumerationResults" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringAttribute("ServiceEndpoint", this.serviceEndpoint);
        xmlWriter.writeStringElement("Prefix", this.prefix);
        xmlWriter.writeStringElement("Marker", this.marker);
        xmlWriter.writeIntElement("MaxResults", this.maxResults);
        if (this.queueItems != null) {
            xmlWriter.writeStartElement("Queues");
            for (QueueItem element : this.queueItems) {
                xmlWriter.writeXml((XmlSerializable)element, "Queue");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement("NextMarker", this.nextMarker);
        return xmlWriter.writeEndElement();
    }

    public static ListQueuesSegmentResponse fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ListQueuesSegmentResponse.fromXml(xmlReader, null);
    }

    public static ListQueuesSegmentResponse fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "EnumerationResults" : rootElementName;
        return (ListQueuesSegmentResponse)xmlReader.readObject(finalRootElementName, reader -> {
            ListQueuesSegmentResponse deserializedListQueuesSegmentResponse = new ListQueuesSegmentResponse();
            deserializedListQueuesSegmentResponse.serviceEndpoint = reader.getStringAttribute(null, "ServiceEndpoint");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Prefix".equals(elementName.getLocalPart())) {
                    deserializedListQueuesSegmentResponse.prefix = reader.getStringElement();
                    continue;
                }
                if ("Marker".equals(elementName.getLocalPart())) {
                    deserializedListQueuesSegmentResponse.marker = reader.getStringElement();
                    continue;
                }
                if ("MaxResults".equals(elementName.getLocalPart())) {
                    deserializedListQueuesSegmentResponse.maxResults = reader.getIntElement();
                    continue;
                }
                if ("Queues".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Queue".equals(elementName.getLocalPart())) {
                            if (deserializedListQueuesSegmentResponse.queueItems == null) {
                                deserializedListQueuesSegmentResponse.queueItems = new ArrayList<QueueItem>();
                            }
                            deserializedListQueuesSegmentResponse.queueItems.add(QueueItem.fromXml(reader, "Queue"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedListQueuesSegmentResponse.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedListQueuesSegmentResponse;
        });
    }
}

