/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.QueueSignedIdentifierWrapper;
import com.azure.storage.queue.implementation.models.QueueStorageExceptionInternal;
import com.azure.storage.queue.implementation.models.QueuesCreateHeaders;
import com.azure.storage.queue.implementation.models.QueuesDeleteHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.QueuesSetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesSetMetadataHeaders;
import com.azure.storage.queue.implementation.util.ModelHelper;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class QueuesImpl {
    private final QueuesService service;
    private final AzureQueueStorageImpl client;

    QueuesImpl(AzureQueueStorageImpl client) {
        this.service = (QueuesService)RestProxy.create(QueuesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesCreateHeaders, Void>> createWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return FluxUtil.withContext(context -> this.createWithResponseAsync(queueName, timeout, metadata, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesCreateHeaders, Void>> createWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.create(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return this.createWithResponseAsync(queueName, timeout, metadata, requestId).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        return this.createWithResponseAsync(queueName, timeout, metadata, requestId, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return FluxUtil.withContext(context -> this.createNoCustomHeadersWithResponseAsync(queueName, timeout, metadata, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.createNoCustomHeaders(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<QueuesCreateHeaders, Void> createWithResponse(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        try {
            String accept = "application/xml";
            return this.service.createSync(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        this.createWithResponse(queueName, timeout, metadata, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createNoCustomHeadersWithResponse(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        try {
            String accept = "application/xml";
            return this.service.createNoCustomHeadersSync(this.client.getUrl(), queueName, timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.deleteWithResponseAsync(queueName, timeout, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesDeleteHeaders, Void>> deleteWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.delete(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, Integer timeout, String requestId) {
        return this.deleteWithResponseAsync(queueName, timeout, requestId).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.deleteWithResponseAsync(queueName, timeout, requestId, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.deleteNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String accept = "application/xml";
        return this.service.deleteNoCustomHeaders(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<QueuesDeleteHeaders, Void> deleteWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            String accept = "application/xml";
            return this.service.deleteSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String queueName, Integer timeout, String requestId) {
        this.deleteWithResponse(queueName, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            String accept = "application/xml";
            return this.service.deleteNoCustomHeadersSync(this.client.getUrl(), queueName, timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getPropertiesWithResponseAsync(queueName, timeout, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getPropertiesWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.getProperties(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String queueName, Integer timeout, String requestId) {
        return this.getPropertiesWithResponseAsync(queueName, timeout, requestId).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getPropertiesAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.getPropertiesWithResponseAsync(queueName, timeout, requestId, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getPropertiesNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getPropertiesNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.getPropertiesNoCustomHeaders(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<QueuesGetPropertiesHeaders, Void> getPropertiesWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.getPropertiesSync(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getProperties(String queueName, Integer timeout, String requestId) {
        this.getPropertiesWithResponse(queueName, timeout, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getPropertiesNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.getPropertiesNoCustomHeadersSync(this.client.getUrl(), queueName, "metadata", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return FluxUtil.withContext(context -> this.setMetadataWithResponseAsync(queueName, timeout, metadata, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadataWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadata(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return this.setMetadataWithResponseAsync(queueName, timeout, metadata, requestId).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadataAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        return this.setMetadataWithResponseAsync(queueName, timeout, metadata, requestId, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        return FluxUtil.withContext(context -> this.setMetadataNoCustomHeadersWithResponseAsync(queueName, timeout, metadata, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        String comp = "metadata";
        String accept = "application/xml";
        return this.service.setMetadataNoCustomHeaders(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<QueuesSetMetadataHeaders, Void> setMetadataWithResponse(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        try {
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.setMetadataSync(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(String queueName, Integer timeout, Map<String, String> metadata, String requestId) {
        this.setMetadataWithResponse(queueName, timeout, metadata, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataNoCustomHeadersWithResponse(String queueName, Integer timeout, Map<String, String> metadata, String requestId, Context context) {
        try {
            String comp = "metadata";
            String accept = "application/xml";
            return this.service.setMetadataNoCustomHeadersSync(this.client.getUrl(), queueName, "metadata", timeout, metadata, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>> getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getAccessPolicyWithResponseAsync(queueName, timeout, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>> getAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueSignedIdentifierWrapper> getAccessPolicyAsync(String queueName, Integer timeout, String requestId) {
        return this.getAccessPolicyWithResponseAsync(queueName, timeout, requestId).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(res -> Mono.justOrEmpty((Object)((QueueSignedIdentifierWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueSignedIdentifierWrapper> getAccessPolicyAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.getAccessPolicyWithResponseAsync(queueName, timeout, requestId, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(res -> Mono.justOrEmpty((Object)((QueueSignedIdentifierWrapper)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId) {
        return FluxUtil.withContext(context -> this.getAccessPolicyNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueSignedIdentifierWrapper>> getAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicyNoCustomHeaders(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper> getAccessPolicyWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            String comp = "acl";
            String accept = "application/xml";
            return this.service.getAccessPolicySync(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueSignedIdentifierWrapper getAccessPolicy(String queueName, Integer timeout, String requestId) {
        try {
            return (QueueSignedIdentifierWrapper)this.getAccessPolicyWithResponse(queueName, timeout, requestId, Context.NONE).getValue();
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId, Context context) {
        try {
            String comp = "acl";
            String accept = "application/xml";
            return this.service.getAccessPolicyNoCustomHeadersSync(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        return FluxUtil.withContext(context -> this.setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        return this.setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        return this.setAccessPolicyWithResponseAsync(queueName, timeout, requestId, queueAcl, context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        return FluxUtil.withContext(context -> this.setAccessPolicyNoCustomHeadersWithResponseAsync(queueName, timeout, requestId, queueAcl, (Context)context)).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyNoCustomHeadersWithResponseAsync(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
        return this.service.setAccessPolicyNoCustomHeaders(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", context).onErrorMap(QueueStorageExceptionInternal.class, ModelHelper::mapToQueueStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<QueuesSetAccessPolicyHeaders, Void> setAccessPolicyWithResponse(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        try {
            String comp = "acl";
            String accept = "application/xml";
            QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
            return this.service.setAccessPolicySync(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl) {
        this.setAccessPolicyWithResponse(queueName, timeout, requestId, queueAcl, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyNoCustomHeadersWithResponse(String queueName, Integer timeout, String requestId, List<QueueSignedIdentifier> queueAcl, Context context) {
        try {
            String comp = "acl";
            String accept = "application/xml";
            QueueSignedIdentifierWrapper queueAclConverted = new QueueSignedIdentifierWrapper(queueAcl);
            return this.service.setAccessPolicyNoCustomHeadersSync(this.client.getUrl(), queueName, "acl", timeout, this.client.getVersion(), requestId, queueAclConverted, "application/xml", context);
        }
        catch (QueueStorageExceptionInternal internalException) {
            throw ModelHelper.mapToQueueStorageException(internalException);
        }
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageQueues")
    public static interface QueuesService {
        @Put(value="/{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<ResponseBase<QueuesCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<Response<Void>> createNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public ResponseBase<QueuesCreateHeaders, Void> createSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Response<Void> createNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<ResponseBase<QueuesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<Response<Void>> deleteNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public ResponseBase<QueuesDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Response<Void> deleteNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<ResponseBase<QueuesGetPropertiesHeaders, Void>> getProperties(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<Response<Void>> getPropertiesNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public ResponseBase<QueuesGetPropertiesHeaders, Void> getPropertiesSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Response<Void> getPropertiesNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<ResponseBase<QueuesSetMetadataHeaders, Void>> setMetadata(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<Response<Void>> setMetadataNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public ResponseBase<QueuesSetMetadataHeaders, Void> setMetadataSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Response<Void> setMetadataNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper>> getAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<Response<QueueSignedIdentifierWrapper>> getAccessPolicyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper> getAccessPolicySync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{queueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Response<QueueSignedIdentifierWrapper> getAccessPolicyNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<ResponseBase<QueuesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueSignedIdentifierWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Mono<Response<Void>> setAccessPolicyNoCustomHeaders(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueSignedIdentifierWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public ResponseBase<QueuesSetAccessPolicyHeaders, Void> setAccessPolicySync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueSignedIdentifierWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{queueName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageExceptionInternal.class)
        public Response<Void> setAccessPolicyNoCustomHeadersSync(@HostParam(value="url") String var1, @PathParam(value="queueName") String var2, @QueryParam(value="comp") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @BodyParam(value="application/xml") QueueSignedIdentifierWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

