/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.models;

import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SendMessageResult
implements XmlSerializable<SendMessageResult> {
    private String messageId;
    private DateTimeRfc1123 insertionTime;
    private DateTimeRfc1123 expirationTime;
    private String popReceipt;
    private DateTimeRfc1123 timeNextVisible;

    public String getMessageId() {
        return this.messageId;
    }

    public SendMessageResult setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public OffsetDateTime getInsertionTime() {
        if (this.insertionTime == null) {
            return null;
        }
        return this.insertionTime.getDateTime();
    }

    public SendMessageResult setInsertionTime(OffsetDateTime insertionTime) {
        this.insertionTime = insertionTime == null ? null : new DateTimeRfc1123(insertionTime);
        return this;
    }

    public OffsetDateTime getExpirationTime() {
        if (this.expirationTime == null) {
            return null;
        }
        return this.expirationTime.getDateTime();
    }

    public SendMessageResult setExpirationTime(OffsetDateTime expirationTime) {
        this.expirationTime = expirationTime == null ? null : new DateTimeRfc1123(expirationTime);
        return this;
    }

    public String getPopReceipt() {
        return this.popReceipt;
    }

    public SendMessageResult setPopReceipt(String popReceipt) {
        this.popReceipt = popReceipt;
        return this;
    }

    public OffsetDateTime getTimeNextVisible() {
        if (this.timeNextVisible == null) {
            return null;
        }
        return this.timeNextVisible.getDateTime();
    }

    public SendMessageResult setTimeNextVisible(OffsetDateTime timeNextVisible) {
        this.timeNextVisible = timeNextVisible == null ? null : new DateTimeRfc1123(timeNextVisible);
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueMessage" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("MessageId", this.messageId);
        xmlWriter.writeStringElement("InsertionTime", Objects.toString(this.insertionTime, null));
        xmlWriter.writeStringElement("ExpirationTime", Objects.toString(this.expirationTime, null));
        xmlWriter.writeStringElement("PopReceipt", this.popReceipt);
        xmlWriter.writeStringElement("TimeNextVisible", Objects.toString(this.timeNextVisible, null));
        return xmlWriter.writeEndElement();
    }

    public static SendMessageResult fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SendMessageResult.fromXml(xmlReader, null);
    }

    public static SendMessageResult fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "QueueMessage" : rootElementName;
        return (SendMessageResult)xmlReader.readObject(finalRootElementName, reader -> {
            SendMessageResult deserializedSendMessageResult = new SendMessageResult();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("MessageId".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.messageId = reader.getStringElement();
                    continue;
                }
                if ("InsertionTime".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.insertionTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("ExpirationTime".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.expirationTime = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("PopReceipt".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.popReceipt = reader.getStringElement();
                    continue;
                }
                if ("TimeNextVisible".equals(elementName.getLocalPart())) {
                    deserializedSendMessageResult.timeNextVisible = (DateTimeRfc1123)reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSendMessageResult;
        });
    }
}

