/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueClientBuilder;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessageIdsUpdateHeaders;
import com.azure.storage.queue.implementation.models.MessagesDequeueHeaders;
import com.azure.storage.queue.implementation.models.MessagesPeekHeaders;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternal;
import com.azure.storage.queue.implementation.models.PeekedMessageItemInternalWrapper;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternal;
import com.azure.storage.queue.implementation.models.QueueMessageItemInternalWrapper;
import com.azure.storage.queue.implementation.models.QueueSignedIdentifierWrapper;
import com.azure.storage.queue.implementation.models.QueuesGetAccessPolicyHeaders;
import com.azure.storage.queue.implementation.models.QueuesGetPropertiesHeaders;
import com.azure.storage.queue.implementation.models.SendMessageResultWrapper;
import com.azure.storage.queue.implementation.util.ModelHelper;
import com.azure.storage.queue.implementation.util.QueueSasImplUtil;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueMessageDecodingError;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueueProperties;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.storage.queue.models.QueueStorageException;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.storage.queue.models.UpdateMessageResult;
import com.azure.storage.queue.sas.QueueServiceSasSignatureValues;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=QueueClientBuilder.class)
public final class QueueClient {
    private static final ClientLogger LOGGER = new ClientLogger(QueueClient.class);
    private final AzureQueueStorageImpl azureQueueStorage;
    private final String queueName;
    private final String accountName;
    private final QueueServiceVersion serviceVersion;
    private final QueueMessageEncoding messageEncoding;
    private final Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler;
    private final Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler;
    private final QueueAsyncClient asyncClient;

    QueueClient(AzureQueueStorageImpl azureQueueStorage, String queueName, String accountName, QueueServiceVersion serviceVersion, QueueMessageEncoding messageEncoding, Function<QueueMessageDecodingError, Mono<Void>> processMessageDecodingErrorAsyncHandler, Consumer<QueueMessageDecodingError> processMessageDecodingErrorHandler, QueueAsyncClient asyncClient) {
        Objects.requireNonNull(queueName, "'queueName' cannot be null.");
        this.azureQueueStorage = azureQueueStorage;
        this.queueName = queueName;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.messageEncoding = messageEncoding;
        this.processMessageDecodingErrorAsyncHandler = processMessageDecodingErrorAsyncHandler;
        this.processMessageDecodingErrorHandler = processMessageDecodingErrorHandler;
        this.asyncClient = asyncClient;
    }

    public String getQueueUrl() {
        return this.azureQueueStorage.getUrl() + "/" + this.queueName;
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.messageEncoding;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureQueueStorage.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create() {
        this.createWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Supplier<Response> operation = () -> this.azureQueueStorage.getQueues().createNoCustomHeadersWithResponse(this.queueName, null, metadata, null, finalContext);
            return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean createIfNotExists() {
        return (Boolean)this.createIfNotExistsWithResponse(null, null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> createIfNotExistsWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Supplier<Response> operation = () -> this.azureQueueStorage.getQueues().createNoCustomHeadersWithResponse(this.queueName, null, metadata, null, finalContext);
            Response response = (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
            return new SimpleResponse(response, (Object)true);
        }
        catch (QueueStorageException e) {
            if (e.getStatusCode() == 409) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getQueues().deleteNoCustomHeadersWithResponse(this.queueName, null, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return (Boolean)this.deleteIfExistsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        try {
            Supplier<Response> operation = () -> this.azureQueueStorage.getQueues().deleteNoCustomHeadersWithResponse(this.queueName, null, null, finalContext);
            Response response = (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
            return new SimpleResponse(response, (Object)true);
        }
        catch (QueueStorageException e) {
            if (e.getStatusCode() == 404) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse(res.getRequest(), res.getStatusCode(), res.getHeaders(), (Object)false);
            }
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)e));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties getProperties() {
        return (QueueProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<ResponseBase> operation = () -> this.azureQueueStorage.getQueues().getPropertiesWithResponse(this.queueName, null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        return new SimpleResponse((Response)response, (Object)ModelHelper.transformQueueProperties((QueuesGetPropertiesHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getQueues().setMetadataNoCustomHeadersWithResponse(this.queueName, null, metadata, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueSignedIdentifier> getAccessPolicy() {
        ResponseBase<QueuesGetAccessPolicyHeaders, QueueSignedIdentifierWrapper> responseBase = this.azureQueueStorage.getQueues().getAccessPolicyWithResponse(this.queueName, null, null, Context.NONE);
        Supplier<PagedResponse> response = () -> new PagedResponseBase(responseBase.getRequest(), responseBase.getStatusCode(), responseBase.getHeaders(), ((QueueSignedIdentifierWrapper)responseBase.getValue()).items(), null, (Object)((QueuesGetAccessPolicyHeaders)responseBase.getDeserializedHeaders()));
        return new PagedIterable(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(List<QueueSignedIdentifier> permissions) {
        this.setAccessPolicyWithResponse(permissions, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyWithResponse(List<QueueSignedIdentifier> permissions, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getQueues().setAccessPolicyNoCustomHeadersWithResponse(this.queueName, null, null, permissions, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void clearMessages() {
        this.clearMessagesWithResponse(null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> clearMessagesWithResponse(Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getMessages().clearNoCustomHeadersWithResponse(this.queueName, null, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendMessageResult sendMessage(String messageText) {
        return (SendMessageResult)this.sendMessageWithResponse(messageText, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendMessageResult sendMessage(BinaryData message) {
        return (SendMessageResult)this.sendMessageWithResponse(message, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendMessageResult> sendMessageWithResponse(String messageText, Duration visibilityTimeout, Duration timeToLive, Duration timeout, Context context) {
        return this.sendMessageWithResponse(BinaryData.fromString((String)messageText), visibilityTimeout, timeToLive, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendMessageResult> sendMessageWithResponse(BinaryData message, Duration visibilityTimeout, Duration timeToLive, Duration timeout, Context context) {
        Integer visibilityTimeoutInSeconds = visibilityTimeout == null ? null : Integer.valueOf((int)visibilityTimeout.getSeconds());
        Integer timeToLiveInSeconds = timeToLive == null ? null : Integer.valueOf((int)timeToLive.getSeconds());
        Context finalContext = context == null ? Context.NONE : context;
        String finalMessage = ModelHelper.encodeMessage(message, this.messageEncoding);
        QueueMessage queueMessage = new QueueMessage().setMessageText(finalMessage);
        Supplier<ResponseBase> operation = () -> this.azureQueueStorage.getMessages().enqueueWithResponse(this.queueName, queueMessage, visibilityTimeoutInSeconds, timeToLiveInSeconds, null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        return new SimpleResponse((Response)response, (Object)((SendMessageResultWrapper)response.getValue()).items().get(0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueMessageItem receiveMessage() {
        List result = this.receiveMessagesWithOptionalTimeout(1, null, null, Context.NONE).stream().collect(Collectors.toList());
        return result.isEmpty() ? null : (QueueMessageItem)result.get(0);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueMessageItem> receiveMessages(Integer maxMessages) {
        return this.receiveMessages(maxMessages, Duration.ofSeconds(30L), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueMessageItem> receiveMessages(Integer maxMessages, Duration visibilityTimeout, Duration timeout, Context context) {
        return this.receiveMessagesWithOptionalTimeout(maxMessages, visibilityTimeout, timeout, context);
    }

    PagedIterable<QueueMessageItem> receiveMessagesWithOptionalTimeout(Integer maxMessages, Duration visibilityTimeout, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Integer visibilityTimeoutInSeconds = visibilityTimeout == null ? null : Integer.valueOf((int)visibilityTimeout.getSeconds());
        Supplier<ResponseBase> operation = () -> this.azureQueueStorage.getMessages().dequeueWithResponse(this.queueName, maxMessages, visibilityTimeoutInSeconds, null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        PagedResponseBase<MessagesDequeueHeaders, QueueMessageItem> transformedMessages = this.transformMessagesDequeueResponse((ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper>)response);
        Supplier<PagedResponse> res = () -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Page)transformedMessages, (Object)((MessagesDequeueHeaders)response.getDeserializedHeaders()));
        return new PagedIterable(res);
    }

    private PagedResponseBase<MessagesDequeueHeaders, QueueMessageItem> transformMessagesDequeueResponse(ResponseBase<MessagesDequeueHeaders, QueueMessageItemInternalWrapper> response) {
        List<QueueMessageItemInternal> queueMessageInternalItems = ((QueueMessageItemInternalWrapper)response.getValue()).items();
        if (queueMessageInternalItems == null) {
            queueMessageInternalItems = Collections.emptyList();
        }
        ArrayList<QueueMessageItem> messageItems = new ArrayList<QueueMessageItem>();
        for (QueueMessageItemInternal queueMessageInternalItem : queueMessageInternalItems) {
            try {
                QueueMessageItem decodedMessage = ModelHelper.transformQueueMessageItemInternal(queueMessageInternalItem, this.messageEncoding);
                messageItems.add(decodedMessage);
            }
            catch (IllegalArgumentException e) {
                QueueMessageItem transformedQueueMessageItem;
                if (this.processMessageDecodingErrorAsyncHandler != null) {
                    transformedQueueMessageItem = ModelHelper.transformQueueMessageItemInternal(queueMessageInternalItem, QueueMessageEncoding.NONE);
                    this.processMessageDecodingErrorAsyncHandler.apply(new QueueMessageDecodingError(this.asyncClient, this, transformedQueueMessageItem, null, e));
                    continue;
                }
                if (this.processMessageDecodingErrorHandler != null) {
                    transformedQueueMessageItem = ModelHelper.transformQueueMessageItemInternal(queueMessageInternalItem, QueueMessageEncoding.NONE);
                    this.processMessageDecodingErrorHandler.accept(new QueueMessageDecodingError(this.asyncClient, this, transformedQueueMessageItem, null, e));
                    continue;
                }
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), messageItems, null, (Object)((MessagesDequeueHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PeekedMessageItem peekMessage() {
        Iterator iterator = this.peekMessages(null, null, null).iterator();
        return iterator.hasNext() ? (PeekedMessageItem)iterator.next() : null;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PeekedMessageItem> peekMessages(Integer maxMessages, Duration timeout, Context context) {
        return this.peekMessagesWithOptionalTimeout(maxMessages, timeout, context);
    }

    PagedIterable<PeekedMessageItem> peekMessagesWithOptionalTimeout(Integer maxMessages, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<ResponseBase> operation = () -> this.azureQueueStorage.getMessages().peekWithResponse(this.queueName, maxMessages, null, null, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        PagedResponseBase<MessagesPeekHeaders, PeekedMessageItem> transformedMessages = this.transformMessagesPeekResponse((ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper>)response);
        Supplier<PagedResponse> res = () -> new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Page)transformedMessages, (Object)((MessagesPeekHeaders)response.getDeserializedHeaders()));
        return new PagedIterable(res);
    }

    private PagedResponseBase<MessagesPeekHeaders, PeekedMessageItem> transformMessagesPeekResponse(ResponseBase<MessagesPeekHeaders, PeekedMessageItemInternalWrapper> response) {
        List<PeekedMessageItemInternal> peekedMessageInternalItems = ((PeekedMessageItemInternalWrapper)response.getValue()).items();
        if (peekedMessageInternalItems == null) {
            peekedMessageInternalItems = Collections.emptyList();
        }
        ArrayList<PeekedMessageItem> messageItems = new ArrayList<PeekedMessageItem>();
        for (PeekedMessageItemInternal peekedMessageInternalItem : peekedMessageInternalItems) {
            try {
                PeekedMessageItem peekedMessageItem = ModelHelper.transformPeekedMessageItemInternal(peekedMessageInternalItem, this.messageEncoding);
                messageItems.add(peekedMessageItem);
            }
            catch (IllegalArgumentException e) {
                PeekedMessageItem transformedPeekedMessageItem;
                if (this.processMessageDecodingErrorAsyncHandler != null) {
                    transformedPeekedMessageItem = ModelHelper.transformPeekedMessageItemInternal(peekedMessageInternalItem, QueueMessageEncoding.NONE);
                    this.processMessageDecodingErrorAsyncHandler.apply(new QueueMessageDecodingError(this.asyncClient, this, null, transformedPeekedMessageItem, e));
                    continue;
                }
                if (this.processMessageDecodingErrorHandler != null) {
                    transformedPeekedMessageItem = ModelHelper.transformPeekedMessageItemInternal(peekedMessageInternalItem, QueueMessageEncoding.NONE);
                    this.processMessageDecodingErrorHandler.accept(new QueueMessageDecodingError(this.asyncClient, this, null, transformedPeekedMessageItem, e));
                    continue;
                }
                throw LOGGER.logExceptionAsError((RuntimeException)e);
            }
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), messageItems, null, (Object)((MessagesPeekHeaders)response.getDeserializedHeaders()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UpdateMessageResult updateMessage(String messageId, String popReceipt, String messageText, Duration visibilityTimeout) {
        return (UpdateMessageResult)this.updateMessageWithResponse(messageId, popReceipt, messageText, visibilityTimeout, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UpdateMessageResult> updateMessageWithResponse(String messageId, String popReceipt, String messageText, Duration visibilityTimeout, Duration timeout, Context context) {
        QueueMessage message;
        if (messageText != null) {
            String finalMessage = ModelHelper.encodeMessage(BinaryData.fromString((String)messageText), this.messageEncoding);
            message = new QueueMessage().setMessageText(finalMessage);
        } else {
            message = null;
        }
        Context finalContext = context == null ? Context.NONE : context;
        Duration finalVisibilityTimeout = visibilityTimeout == null ? Duration.ZERO : visibilityTimeout;
        Supplier<ResponseBase> operation = () -> this.azureQueueStorage.getMessageIds().updateWithResponse(this.queueName, messageId, popReceipt, (int)finalVisibilityTimeout.getSeconds(), null, null, message, finalContext);
        ResponseBase response = (ResponseBase)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
        UpdateMessageResult result = new UpdateMessageResult(((MessageIdsUpdateHeaders)response.getDeserializedHeaders()).getXMsPopreceipt(), ((MessageIdsUpdateHeaders)response.getDeserializedHeaders()).getXMsTimeNextVisible());
        return new SimpleResponse((Response)response, (Object)result);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteMessage(String messageId, String popReceipt) {
        this.deleteMessageWithResponse(messageId, popReceipt, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteMessageWithResponse(String messageId, String popReceipt, Duration timeout, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        Supplier<Response> operation = () -> this.azureQueueStorage.getMessageIds().deleteNoCustomHeadersWithResponse(this.queueName, messageId, popReceipt, null, null, finalContext);
        return (Response)StorageImplUtils.submitThreadPool(operation, (ClientLogger)LOGGER, (Duration)timeout);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues) {
        return this.generateSas(queueServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues, Context context) {
        return this.generateSas(queueServiceSasSignatureValues, null, context);
    }

    public String generateSas(QueueServiceSasSignatureValues queueServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new QueueSasImplUtil(queueServiceSasSignatureValues, this.getQueueName()).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }
}

