// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation.models;

import com.azure.storage.queue.models.SendMessageResult;
import java.util.List;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A wrapper around List&lt;SendMessageResult&gt; which provides top-level metadata for serialization.
 */
public final class SendMessageResultWrapper implements XmlSerializable<SendMessageResultWrapper> {
    private final List<SendMessageResult> queueMessagesList;

    /**
     * Creates an instance of SendMessageResultWrapper.
     * 
     * @param queueMessagesList the list.
     */
    public SendMessageResultWrapper(List<SendMessageResult> queueMessagesList) {
        this.queueMessagesList = queueMessagesList;
    }

    /**
     * Get the List&lt;SendMessageResult&gt; contained in this wrapper.
     * 
     * @return the List&lt;SendMessageResult&gt;.
     */
    public List<SendMessageResult> items() {
        return queueMessagesList;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessagesList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (queueMessagesList != null) {
            for (SendMessageResult element : queueMessagesList) {
                xmlWriter.writeXml(element, "QueueMessage");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static SendMessageResultWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    public static SendMessageResultWrapper fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueueMessagesList" : rootElementName;
        return xmlReader.readObject(rootElementName, reader -> {
            List<SendMessageResult> items = null;

            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("QueueMessage".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<>();
                    }

                    items.add(SendMessageResult.fromXml(reader));
                } else {
                    reader.nextElement();
                }
            }
            return new SendMessageResultWrapper(items);
        });
    }
}
