// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/**
 * The QueuesGetPropertiesHeaders model.
 */
@Fluent
public final class QueuesGetPropertiesHeaders {
    /*
     * The x-ms-version property.
     */
    private String xMsVersion;

    /*
     * The x-ms-approximate-messages-count property.
     */
    private Integer xMsApproximateMessagesCount;

    /*
     * The x-ms-meta- property.
     */
    private Map<String, String> xMsMeta;

    /*
     * The x-ms-request-id property.
     */
    private String xMsRequestId;

    /*
     * The Date property.
     */
    private DateTimeRfc1123 date;

    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString("x-ms-version");

    private static final HttpHeaderName X_MS_APPROXIMATE_MESSAGES_COUNT
        = HttpHeaderName.fromString("x-ms-approximate-messages-count");

    // HttpHeaders containing the raw property values.
    /**
     * Creates an instance of QueuesGetPropertiesHeaders class.
     * 
     * @param rawHeaders The raw HttpHeaders that will be used to create the property values.
     */
    public QueuesGetPropertiesHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        String xMsApproximateMessagesCount = rawHeaders.getValue(X_MS_APPROXIMATE_MESSAGES_COUNT);
        if (xMsApproximateMessagesCount != null) {
            this.xMsApproximateMessagesCount = Integer.parseInt(xMsApproximateMessagesCount);
        }
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        if (date != null) {
            this.date = new DateTimeRfc1123(date);
        }
        Map<String, String> xMsMetaHeaderCollection = new HashMap<>();

        for (HttpHeader header : rawHeaders) {
            String headerName = header.getName();
            if (headerName.startsWith("x-ms-meta-")) {
                xMsMetaHeaderCollection.put(headerName.substring(10), header.getValue());
            }
        }

        this.xMsMeta = xMsMetaHeaderCollection;
    }

    /**
     * Get the xMsVersion property: The x-ms-version property.
     * 
     * @return the xMsVersion value.
     */
    public String getXMsVersion() {
        return this.xMsVersion;
    }

    /**
     * Set the xMsVersion property: The x-ms-version property.
     * 
     * @param xMsVersion the xMsVersion value to set.
     * @return the QueuesGetPropertiesHeaders object itself.
     */
    public QueuesGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    /**
     * Get the xMsApproximateMessagesCount property: The x-ms-approximate-messages-count property.
     * 
     * @return the xMsApproximateMessagesCount value.
     */
    public Integer getXMsApproximateMessagesCount() {
        return this.xMsApproximateMessagesCount;
    }

    /**
     * Set the xMsApproximateMessagesCount property: The x-ms-approximate-messages-count property.
     * 
     * @param xMsApproximateMessagesCount the xMsApproximateMessagesCount value to set.
     * @return the QueuesGetPropertiesHeaders object itself.
     */
    public QueuesGetPropertiesHeaders setXMsApproximateMessagesCount(Integer xMsApproximateMessagesCount) {
        this.xMsApproximateMessagesCount = xMsApproximateMessagesCount;
        return this;
    }

    /**
     * Get the xMsMeta property: The x-ms-meta- property.
     * 
     * @return the xMsMeta value.
     */
    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    /**
     * Set the xMsMeta property: The x-ms-meta- property.
     * 
     * @param xMsMeta the xMsMeta value to set.
     * @return the QueuesGetPropertiesHeaders object itself.
     */
    public QueuesGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    /**
     * Get the xMsRequestId property: The x-ms-request-id property.
     * 
     * @return the xMsRequestId value.
     */
    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    /**
     * Set the xMsRequestId property: The x-ms-request-id property.
     * 
     * @param xMsRequestId the xMsRequestId value to set.
     * @return the QueuesGetPropertiesHeaders object itself.
     */
    public QueuesGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    /**
     * Get the date property: The Date property.
     * 
     * @return the date value.
     */
    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    /**
     * Set the date property: The Date property.
     * 
     * @param date the date value to set.
     * @return the QueuesGetPropertiesHeaders object itself.
     */
    public QueuesGetPropertiesHeaders setDate(OffsetDateTime date) {
        if (date == null) {
            this.date = null;
        } else {
            this.date = new DateTimeRfc1123(date);
        }
        return this;
    }
}
