// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.queue.implementation.models;

import com.azure.storage.queue.models.QueueSignedIdentifier;
import java.util.List;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * A wrapper around List&lt;QueueSignedIdentifier&gt; which provides top-level metadata for serialization.
 */
public final class QueueSignedIdentifierWrapper implements XmlSerializable<QueueSignedIdentifierWrapper> {
    private final List<QueueSignedIdentifier> signedIdentifiers;

    /**
     * Creates an instance of QueueSignedIdentifierWrapper.
     * 
     * @param signedIdentifiers the list.
     */
    public QueueSignedIdentifierWrapper(List<QueueSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    /**
     * Get the List&lt;QueueSignedIdentifier&gt; contained in this wrapper.
     * 
     * @return the List&lt;QueueSignedIdentifier&gt;.
     */
    public List<QueueSignedIdentifier> items() {
        return signedIdentifiers;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (signedIdentifiers != null) {
            for (QueueSignedIdentifier element : signedIdentifiers) {
                xmlWriter.writeXml(element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static QueueSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    public static QueueSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "SignedIdentifiers" : rootElementName;
        return xmlReader.readObject(rootElementName, reader -> {
            List<QueueSignedIdentifier> items = null;

            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<>();
                    }

                    items.add(QueueSignedIdentifier.fromXml(reader));
                } else {
                    reader.nextElement();
                }
            }
            return new QueueSignedIdentifierWrapper(items);
        });
    }
}
