/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.protocol;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.HttpRequestInterceptor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

