/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class JREKeyStoreFactory {
    private static final String JAVA_HOME = JREKeyStoreFactory.privilegedGetProperty("java.home", "");
    private static final Path STORE_PATH = Paths.get(JAVA_HOME, new String[0]).resolve("lib").resolve("security");
    private static final Path DEFAULT_STORE = STORE_PATH.resolve("cacerts");
    private static final Path JSSE_DEFAULT_STORE = STORE_PATH.resolve("jssecacerts");
    private static final String KEY_STORE_PASSWORD = JREKeyStoreFactory.privilegedGetProperty("javax.net.ssl.keyStorePassword", "changeit");
    private static final Logger LOGGER = Logger.getLogger(JREKeyStoreFactory.class.getName());
    private static final KeyStore JRE_KEY_STORE = JREKeyStoreFactory.getJreKeyStore();

    private JREKeyStoreFactory() {
    }

    public static KeyStore getDefaultKeyStore() {
        return JRE_KEY_STORE;
    }

    private static KeyStore getJreKeyStore() {
        KeyStore defaultKeyStore = null;
        try {
            defaultKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            JREKeyStoreFactory.loadKeyStore(defaultKeyStore);
        }
        catch (KeyStoreException e) {
            LOGGER.log(Level.WARNING, "Unable to get the jre key store.", e);
        }
        return defaultKeyStore;
    }

    private static void loadKeyStore(KeyStore ks) {
        try (InputStream inputStream = Files.newInputStream(JREKeyStoreFactory.getKeyStoreFile(), new OpenOption[0]);){
            ks.load(inputStream, KEY_STORE_PASSWORD.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LOGGER.log(Level.WARNING, "unable to load the jre key store", e);
        }
    }

    private static Path getKeyStoreFile() {
        return Stream.of(JREKeyStoreFactory.getConfiguredKeyStorePath(), JSSE_DEFAULT_STORE, DEFAULT_STORE).filter(Objects::nonNull).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Files::isReadable).findFirst().orElse(null);
    }

    private static Path getConfiguredKeyStorePath() {
        String configuredKeyStorePath = JREKeyStoreFactory.privilegedGetProperty("javax.net.ssl.keyStore", "");
        return Optional.of(configuredKeyStorePath).filter(path -> !path.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
    }

    private static String privilegedGetProperty(String theProp, String defaultVal) {
        return AccessController.doPrivileged(() -> {
            String value = System.getProperty(theProp, "");
            return value.isEmpty() ? defaultVal : value;
        });
    }
}

