/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider;

import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServiceConstraintsException;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServiceProperties;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static final Logger LOG = Logger.getLogger(BouncyCastleProvider.class.getName());
    private static String info = CryptoServicesRegistrar.getInfo().replace("APIs", "Security Provider");
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, (String)"java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final CryptoServiceProperties[] SYMMETRIC_CIPHERS = new CryptoServiceProperties[]{BouncyCastleProvider.service((String)"AES", (int)256), BouncyCastleProvider.service((String)"ARC4", (int)20), BouncyCastleProvider.service((String)"ARIA", (int)256), BouncyCastleProvider.service((String)"Blowfish", (int)128), BouncyCastleProvider.service((String)"Camellia", (int)256), BouncyCastleProvider.service((String)"CAST5", (int)128), BouncyCastleProvider.service((String)"CAST6", (int)256), BouncyCastleProvider.service((String)"ChaCha", (int)128), BouncyCastleProvider.service((String)"DES", (int)56), BouncyCastleProvider.service((String)"DESede", (int)112), BouncyCastleProvider.service((String)"GOST28147", (int)128), BouncyCastleProvider.service((String)"Grainv1", (int)128), BouncyCastleProvider.service((String)"Grain128", (int)128), BouncyCastleProvider.service((String)"HC128", (int)128), BouncyCastleProvider.service((String)"HC256", (int)256), BouncyCastleProvider.service((String)"IDEA", (int)128), BouncyCastleProvider.service((String)"Noekeon", (int)128), BouncyCastleProvider.service((String)"RC2", (int)128), BouncyCastleProvider.service((String)"RC5", (int)128), BouncyCastleProvider.service((String)"RC6", (int)256), BouncyCastleProvider.service((String)"Rijndael", (int)256), BouncyCastleProvider.service((String)"Salsa20", (int)128), BouncyCastleProvider.service((String)"SEED", (int)128), BouncyCastleProvider.service((String)"Serpent", (int)256), BouncyCastleProvider.service((String)"Shacal2", (int)128), BouncyCastleProvider.service((String)"Skipjack", (int)80), BouncyCastleProvider.service((String)"SM4", (int)128), BouncyCastleProvider.service((String)"TEA", (int)128), BouncyCastleProvider.service((String)"Twofish", (int)256), BouncyCastleProvider.service((String)"Threefish", (int)128), BouncyCastleProvider.service((String)"VMPC", (int)128), BouncyCastleProvider.service((String)"VMPCKSA3", (int)128), BouncyCastleProvider.service((String)"XTEA", (int)128), BouncyCastleProvider.service((String)"XSalsa20", (int)128), BouncyCastleProvider.service((String)"OpenSSLPBKDF", (int)128), BouncyCastleProvider.service((String)"DSTU7624", (int)256), BouncyCastleProvider.service((String)"GOST3412_2015", (int)256), BouncyCastleProvider.service((String)"Zuc", (int)128)};
    private static final String ASYMMETRIC_PACKAGE = "com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE", "EXTERNAL", "CompositeSignatures"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC", "LMS", "CONTEXT", "SLHDSA", "MLDSA", "MLKEM"};
    private static final String DIGEST_PACKAGE = "com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka", "Blake3"};
    private static final String KEYSTORE_PACKAGE = "com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};
    private Map<String, Provider.Service> serviceMap = new ConcurrentHashMap();

    public BouncyCastleProvider() {
        super("BC", 2.7307, info);
        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setup() {
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.digest.", DIGESTS);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_GENERIC);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_MACS);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.symmetric.", SYMMETRIC_CIPHERS);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_GENERIC);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.asymmetric.", ASYMMETRIC_CIPHERS);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.keystore.", KEYSTORES);
        this.loadAlgorithms("com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jcajce.provider.drbg.", SECURE_RANDOMS);
        this.loadPQCKeys();
        if (revChkClass != null) {
            this.put((Object)"CertPathValidator.RFC5280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.RFC5280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            this.put((Object)"CertPathValidator.PKIX", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            this.put((Object)"CertPathValidator.RFC5280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC5280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.RFC3280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.RFC3280", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            this.put((Object)"CertPathValidator.PKIX", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            this.put((Object)"CertPathBuilder.PKIX", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        this.put((Object)"CertStore.Collection", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.CertStoreCollectionSpi");
        this.put((Object)"CertStore.LDAP", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        this.put((Object)"CertStore.Multi", (Object)"com.azure.security.keyvault.jca.implementation.shaded.org.bouncycastle.jce.provider.MultiCertStoreSpi");
        this.put((Object)"Alg.Alias.CertStore.X509LDAP", (Object)"LDAP");
        this.getService("SecureRandom", "DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Provider.Service getService(String string, String string2) {
        String string3 = Strings.toUpperCase(string2);
        String string4 = string + "." + string3;
        Provider.Service service = (Provider.Service)this.serviceMap.get(string4);
        if (service == null) {
            BouncyCastleProvider bouncyCastleProvider = this;
            synchronized (bouncyCastleProvider) {
                service = !this.serviceMap.containsKey(string4) ? (Provider.Service)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */) : (Provider.Service)this.serviceMap.get(string4);
            }
        }
        return service;
    }

    private void loadAlgorithms(String string, String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            this.loadServiceClass(string, stringArray[i]);
        }
    }

    private void loadAlgorithms(String string, CryptoServiceProperties[] cryptoServicePropertiesArray) {
        for (int i = 0; i != cryptoServicePropertiesArray.length; ++i) {
            CryptoServiceProperties cryptoServiceProperties = cryptoServicePropertiesArray[i];
            try {
                CryptoServicesRegistrar.checkConstraints(cryptoServiceProperties);
                this.loadServiceClass(string, cryptoServiceProperties.getServiceName());
                continue;
            }
            catch (CryptoServiceConstraintsException cryptoServiceConstraintsException) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("service for " + cryptoServiceProperties.getServiceName() + " ignored due to constraints");
            }
        }
    }

    private void loadServiceClass(String string, String string2) {
        Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, (String)(string + string2 + "$Mappings"));
        if (clazz != null) {
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure((ConfigurableProvider)this);
            }
            catch (Exception exception) {
                throw new InternalError("cannot create instance of " + string + string2 + "$Mappings : " + exception);
            }
        }
    }

    private void loadPQCKeys() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String string, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)CONFIGURATION).setParameter(string, object);
        }
    }

    public boolean hasAlgorithm(String string, String string2) {
        return this.containsKey((Object)(string + "." + string2)) || this.containsKey((Object)("Alg.Alias." + string + "." + string2));
    }

    public void addAlgorithm(String string, String string2) {
        if (this.containsKey((Object)string)) {
            throw new IllegalStateException("duplicate provider key (" + string + ") found");
        }
        this.put((Object)string, (Object)string2);
    }

    public void addAlgorithm(String string, String string2, Map<String, String> map) {
        this.addAlgorithm(string, string2);
        this.addAttributes(string, map);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        this.addAlgorithm(string + "." + aSN1ObjectIdentifier, string2);
        this.addAlgorithm(string + ".OID." + aSN1ObjectIdentifier, string2);
    }

    public void addAlgorithm(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2, Map<String, String> map) {
        this.addAlgorithm(string, aSN1ObjectIdentifier, string2);
        this.addAttributes(string + "." + aSN1ObjectIdentifier, map);
        this.addAttributes(string + ".OID." + aSN1ObjectIdentifier, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map map = keyInfoConverters;
        synchronized (map) {
            keyInfoConverters.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
        }
    }

    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    public void addAttributes(String string, Map<String, String> map) {
        this.put((Object)(string + " ImplementedIn"), (Object)"Software");
        for (String string2 : map.keySet()) {
            String string3 = string + " " + string2;
            if (this.containsKey((Object)string3)) {
                throw new IllegalStateException("duplicate provider attribute key (" + string3 + ") found");
            }
            this.put((Object)string3, (Object)map.get(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter((ASN1ObjectIdentifier)privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    private static CryptoServiceProperties service(String string, int n) {
        return new JcaCryptoService(string, n);
    }

    static /* synthetic */ void access$000(BouncyCastleProvider bouncyCastleProvider) {
        bouncyCastleProvider.setup();
    }

    static /* synthetic */ Provider.Service access$101(BouncyCastleProvider bouncyCastleProvider, String string, String string2) {
        return super.getService(string, string2);
    }

    static /* synthetic */ Map access$200(BouncyCastleProvider bouncyCastleProvider) {
        return bouncyCastleProvider.serviceMap;
    }

    static /* synthetic */ Object access$301(BouncyCastleProvider bouncyCastleProvider, Object object) {
        return super.remove(object);
    }

    static /* synthetic */ void access$401(BouncyCastleProvider bouncyCastleProvider, Provider.Service service) {
        super.putService(service);
    }
}

