/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.io;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ConnectionReuseStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ContentType;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.EntityDetails;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpRequestMapper;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpResponseFactory;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ProtocolVersion;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.UnsupportedHttpVersionException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.config.Http1Config;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.Http1StreamListener;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.impl.ServerSupport;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.HttpRequestHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.HttpServerConnection;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.HttpServerRequestHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.entity.StringEntity;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.support.BasicHttpServerExpectationDecorator;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.support.BasicHttpServerRequestHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.message.MessageSupport;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpCoreContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpProcessor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class HttpService {
    private final HttpProcessor processor;
    private final Http1Config http1Config;
    private final HttpServerRequestHandler requestHandler;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final Http1StreamListener streamListener;

    public HttpService(HttpProcessor processor, HttpRequestMapper<HttpRequestHandler> handlerMapper, ConnectionReuseStrategy connReuseStrategy, HttpResponseFactory<ClassicHttpResponse> responseFactory, Http1StreamListener streamListener) {
        this(processor, new BasicHttpServerExpectationDecorator(new BasicHttpServerRequestHandler(handlerMapper, responseFactory)), Http1Config.DEFAULT, connReuseStrategy, streamListener);
    }

    public HttpService(HttpProcessor processor, HttpRequestMapper<HttpRequestHandler> handlerMapper, ConnectionReuseStrategy connReuseStrategy, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this(processor, handlerMapper, connReuseStrategy, responseFactory, null);
    }

    public HttpService(HttpProcessor processor, HttpServerRequestHandler requestHandler, ConnectionReuseStrategy connReuseStrategy, Http1StreamListener streamListener) {
        this(processor, requestHandler, Http1Config.DEFAULT, connReuseStrategy, streamListener);
    }

    public HttpService(HttpProcessor processor, HttpServerRequestHandler requestHandler, Http1Config http1Config, ConnectionReuseStrategy connReuseStrategy, Http1StreamListener streamListener) {
        this.processor = Args.notNull(processor, "HTTP processor");
        this.requestHandler = Args.notNull(requestHandler, "Request handler");
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.streamListener = streamListener;
    }

    public HttpService(HttpProcessor processor, HttpServerRequestHandler requestHandler) {
        this(processor, requestHandler, Http1Config.DEFAULT, null, null);
    }

    public void handleRequest(final HttpServerConnection conn, HttpContext localContext) throws IOException, HttpException {
        final AtomicBoolean responseSubmitted = new AtomicBoolean();
        final HttpCoreContext context = HttpCoreContext.cast(localContext);
        try {
            final ClassicHttpRequest request = conn.receiveRequestHeader();
            if (request == null) {
                conn.close();
                return;
            }
            if (this.streamListener != null) {
                this.streamListener.onRequestHead(conn, request);
            }
            conn.receiveRequestEntity(request);
            ProtocolVersion transportVersion = request.getVersion();
            if (transportVersion != null && transportVersion.greaterEquals(HttpVersion.HTTP_2)) {
                throw new UnsupportedHttpVersionException(transportVersion);
            }
            context.setProtocolVersion(transportVersion != null ? transportVersion : this.http1Config.getVersion());
            context.setRequest(request);
            context.setSSLSession(conn.getSSLSession());
            context.setEndpointDetails(conn.getEndpointDetails());
            this.processor.process(request, (EntityDetails)request.getEntity(), (HttpContext)context);
            this.requestHandler.handle(request, new HttpServerRequestHandler.ResponseTrigger(){

                @Override
                public void sendInformation(ClassicHttpResponse response) throws HttpException, IOException {
                    if (responseSubmitted.get()) {
                        throw new HttpException("Response already submitted");
                    }
                    if (response.getCode() >= 200) {
                        throw new HttpException("Invalid intermediate response");
                    }
                    if (HttpService.this.streamListener != null) {
                        HttpService.this.streamListener.onResponseHead(conn, response);
                    }
                    conn.sendResponseHeader(response);
                    conn.flush();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void submitResponse(ClassicHttpResponse response) throws HttpException, IOException {
                    try {
                        ProtocolVersion transportVersion = response.getVersion();
                        if (transportVersion != null) {
                            if (!transportVersion.lessEquals(HttpService.this.http1Config.getVersion())) {
                                throw new UnsupportedHttpVersionException(transportVersion);
                            }
                            context.setProtocolVersion(transportVersion);
                        }
                        context.setResponse(response);
                        HttpService.this.processor.process(response, (EntityDetails)response.getEntity(), (HttpContext)context);
                        responseSubmitted.set(true);
                        conn.sendResponseHeader(response);
                        if (HttpService.this.streamListener != null) {
                            HttpService.this.streamListener.onResponseHead(conn, response);
                        }
                        if (MessageSupport.canResponseHaveBody(request.getMethod(), response)) {
                            conn.sendResponseEntity(response);
                        }
                        EntityUtils.consume(request.getEntity());
                        boolean keepAlive = HttpService.this.connReuseStrategy.keepAlive(request, response, context);
                        if (HttpService.this.streamListener != null) {
                            HttpService.this.streamListener.onExchangeComplete(conn, keepAlive);
                        }
                        if (!keepAlive) {
                            conn.close();
                        }
                        conn.flush();
                    }
                    finally {
                        response.close();
                    }
                }
            }, context);
        }
        catch (HttpException ex) {
            if (responseSubmitted.get()) {
                throw ex;
            }
            try (BasicClassicHttpResponse errorResponse = new BasicClassicHttpResponse(500);){
                this.handleException(ex, errorResponse);
                errorResponse.setHeader("Connection", "close");
                context.setResponse(errorResponse);
                this.processor.process(errorResponse, (EntityDetails)errorResponse.getEntity(), (HttpContext)context);
                conn.sendResponseHeader(errorResponse);
                if (this.streamListener != null) {
                    this.streamListener.onResponseHead(conn, errorResponse);
                }
                conn.sendResponseEntity(errorResponse);
                conn.close();
            }
        }
    }

    protected void handleException(HttpException ex, ClassicHttpResponse response) {
        response.setCode(this.toStatusCode(ex));
        response.setEntity(new StringEntity(ServerSupport.toErrorMessage(ex), ContentType.TEXT_PLAIN));
    }

    protected int toStatusCode(Exception ex) {
        return ServerSupport.toStatusCode(ex);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpProcessor processor;
        private HttpServerRequestHandler requestHandler;
        private Http1Config http1Config;
        private ConnectionReuseStrategy connReuseStrategy;
        private Http1StreamListener streamListener;

        private Builder() {
        }

        public Builder withHttpProcessor(HttpProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Builder withHttpServerRequestHandler(HttpServerRequestHandler requestHandler) {
            this.requestHandler = requestHandler;
            return this;
        }

        public Builder withHttp1Config(Http1Config http1Config) {
            this.http1Config = http1Config;
            return this;
        }

        public Builder withConnectionReuseStrategy(ConnectionReuseStrategy connReuseStrategy) {
            this.connReuseStrategy = connReuseStrategy;
            return this;
        }

        public Builder withHttp1StreamListener(Http1StreamListener streamListener) {
            this.streamListener = streamListener;
            return this;
        }

        public HttpService build() {
            return new HttpService(this.processor, this.requestHandler, this.http1Config, this.connReuseStrategy, this.streamListener);
        }
    }
}

