/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.protocol;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.RouteInfo;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.EntityDetails;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.Method;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Args;
import com.azure.security.keyvault.jca.implementation.shaded.org.slf4j.Logger;
import com.azure.security.keyvault.jca.implementation.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        String exchangeId = clientContext.getExchangeId();
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Connection route not set in the context", (Object)exchangeId);
            }
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
    }
}

