/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.impl.classic;

import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.HttpRequestRetryStrategy;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.HttpRoute;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.classic.ExecChain;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.classic.ExecChainHandler;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.config.RequestConfig;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.impl.classic.RequestFailedException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Contract;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.Internal;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpRequest;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpEntity;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.HttpException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.NoHttpResponseException;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Args;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.TimeValue;
import com.azure.security.keyvault.jca.implementation.shaded.org.apache.hc.core5.util.Timeout;
import com.azure.security.keyvault.jca.implementation.shaded.org.slf4j.Logger;
import com.azure.security.keyvault.jca.implementation.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public class HttpRequestRetryExec
implements ExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestRetryExec.class);
    private final HttpRequestRetryStrategy retryStrategy;

    public HttpRequestRetryExec(HttpRequestRetryStrategy retryStrategy) {
        Args.notNull(retryStrategy, "retryStrategy");
        this.retryStrategy = retryStrategy;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull(request, "request");
        Args.notNull(scope, "scope");
        String exchangeId = scope.exchangeId;
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        ClassicHttpRequest currentRequest = request;
        int execCount = 1;
        while (true) {
            block25: {
                ClassicHttpResponse response;
                try {
                    response = chain.proceed(currentRequest, scope);
                }
                catch (IOException ex) {
                    if (scope.execRuntime.isExecutionAborted()) {
                        throw new RequestFailedException("Request aborted");
                    }
                    HttpEntity requestEntity = request.getEntity();
                    if (requestEntity != null && !requestEntity.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                        }
                        throw ex;
                    }
                    if (this.retryStrategy.retryRequest(request, ex, execCount, context)) {
                        TimeValue nextInterval;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} {}", exchangeId, ex.getMessage(), ex);
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Recoverable I/O exception ({}) caught when processing request to {}", (Object)ex.getClass().getName(), (Object)route);
                        }
                        if (TimeValue.isPositive(nextInterval = this.retryStrategy.getRetryInterval(request, ex, execCount, context))) {
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} wait for {}", (Object)exchangeId, (Object)nextInterval);
                                }
                                nextInterval.sleep();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new InterruptedIOException();
                            }
                        }
                        currentRequest = ClassicRequestBuilder.copy(scope.originalRequest).build();
                        break block25;
                    }
                    if (ex instanceof NoHttpResponseException) {
                        NoHttpResponseException updatedex = new NoHttpResponseException(route.getTargetHost().toHostString() + " failed to respond");
                        updatedex.setStackTrace(ex.getStackTrace());
                        throw updatedex;
                    }
                    throw ex;
                }
                try {
                    HttpEntity entity = request.getEntity();
                    if (entity != null && !entity.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                        }
                        return response;
                    }
                    if (this.retryStrategy.retryRequest(response, execCount, context)) {
                        RequestConfig requestConfig;
                        Timeout responseTimeout;
                        TimeValue nextInterval = this.retryStrategy.getRetryInterval(response, execCount, context);
                        if (TimeValue.isPositive(nextInterval) && (responseTimeout = (requestConfig = context.getRequestConfigOrDefault()).getResponseTimeout()) != null && nextInterval.compareTo(responseTimeout) > 0) {
                            return response;
                        }
                        response.close();
                        if (TimeValue.isPositive(nextInterval)) {
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("{} wait for {}", (Object)exchangeId, (Object)nextInterval);
                                }
                                nextInterval.sleep();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new InterruptedIOException();
                            }
                        }
                    } else {
                        return response;
                    }
                    currentRequest = ClassicRequestBuilder.copy(scope.originalRequest).build();
                }
                catch (RuntimeException ex) {
                    response.close();
                    throw ex;
                }
            }
            ++execCount;
        }
    }
}

