/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.implementation;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonUtils {
    public static Number parseNumber(String numberString) {
        int length = numberString.length();
        if (length == 3 && "NaN".equals(numberString)) {
            return Double.NaN;
        }
        if (length == 8 && "Infinity".equals(numberString)) {
            return Double.POSITIVE_INFINITY;
        }
        if (length == 9) {
            if ("+Infinity".equals(numberString)) {
                return Double.POSITIVE_INFINITY;
            }
            if ("-Infinity".equals(numberString)) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        boolean floatingPoint = false;
        for (int i = 0; i < length; ++i) {
            char c = numberString.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            floatingPoint = true;
            break;
        }
        return floatingPoint ? (Number)JsonUtils.handleFloatingPoint(numberString) : (Number)JsonUtils.handleInteger(numberString);
    }

    private static Number handleFloatingPoint(String value) {
        double d = Double.parseDouble(value);
        if (!Double.isInfinite(d)) {
            return d;
        }
        return new BigDecimal(value);
    }

    private static Number handleInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException failedInteger) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException failedLong) {
                failedLong.addSuppressed(failedInteger);
                try {
                    return new BigInteger(value);
                }
                catch (NumberFormatException failedBigDecimal) {
                    failedBigDecimal.addSuppressed(failedLong);
                    throw failedBigDecimal;
                }
            }
        }
    }
}

