/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.jca.implementation.model;

import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonReader;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonSerializable;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonToken;
import com.azure.security.keyvault.jca.implementation.shaded.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public class AccessToken
implements JsonSerializable<AccessToken> {
    private String accessToken;
    private long expiresIn;
    private final OffsetDateTime creationDate = OffsetDateTime.now();

    public long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isExpired() {
        return OffsetDateTime.now().isAfter(this.creationDate.plusSeconds(this.expiresIn - 60L));
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("access_token", this.accessToken);
        jsonWriter.writeNumberField("expires_in", this.expiresIn);
        return jsonWriter.writeEndObject();
    }

    public static AccessToken fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessToken deserializedAccessToken = new AccessToken();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("access_token".equals(fieldName)) {
                    deserializedAccessToken.accessToken = reader.getString();
                    continue;
                }
                if ("expires_in".equals(fieldName)) {
                    deserializedAccessToken.expiresIn = Long.parseLong(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessToken;
        });
    }
}

