/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.websocket;

import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.client.implementation.MessageDecoder;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClientHandshaker handshaker;
    private final AtomicReference<ClientLogger> loggerReference;
    private final MessageDecoder messageDecoder;
    private final Consumer<WebPubSubMessage> messageHandler;
    private ChannelPromise handshakeFuture;
    private CompositeByteBuf compositeByteBuf;
    private CompletableFuture<Void> closeCallbackFuture = null;
    private CloseWebSocketFrame serverCloseWebSocketFrame = null;

    WebSocketClientHandler(WebSocketClientHandshaker handshaker, AtomicReference<ClientLogger> loggerReference, MessageDecoder messageDecoder, Consumer<WebPubSubMessage> messageHandler) {
        this.handshaker = handshaker;
        this.loggerReference = loggerReference;
        this.messageDecoder = messageDecoder;
        this.messageHandler = messageHandler;
    }

    ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext context) {
        this.handshakeFuture = context.newPromise();
        this.compositeByteBuf = context.alloc().compositeBuffer();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.publishBuffer();
    }

    public void channelActive(ChannelHandlerContext context) {
        this.handshaker.handshake(context.channel());
    }

    protected void channelRead0(ChannelHandlerContext context, Object message) {
        if (this.handshakeFuture != null && !this.handshaker.isHandshakeComplete()) {
            Channel channel = context.channel();
            try {
                this.handshaker.finishHandshake(channel, (FullHttpResponse)message);
                this.handshakeFuture.setSuccess();
            }
            catch (WebSocketHandshakeException e) {
                this.handshakeFuture.setFailure((Throwable)e);
            }
            return;
        }
        if (!(message instanceof WebSocketFrame) || !this.processMessage(context, (WebSocketFrame)message)) {
            this.loggerReference.get().atWarning().addKeyValue("messageType", message.getClass()).log("Unknown message type. Skipping.");
            context.fireChannelRead(message);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.handshakeFuture != null && !this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
        WebSocketClientHandler.release(this.compositeByteBuf);
    }

    private boolean processMessage(ChannelHandlerContext context, WebSocketFrame webSocketFrame) {
        Channel channel = context.channel();
        if (webSocketFrame instanceof PingWebSocketFrame) {
            this.loggerReference.get().atVerbose().log("Received PingWebSocketFrame");
            this.loggerReference.get().atVerbose().log("Send PongWebSocketFrame");
            channel.writeAndFlush((Object)new PongWebSocketFrame());
            return true;
        }
        if (webSocketFrame instanceof PongWebSocketFrame) {
            this.loggerReference.get().atVerbose().log("Received PongWebSocketFrame");
            return true;
        }
        if (webSocketFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)webSocketFrame;
            this.loggerReference.get().atVerbose().addKeyValue("statusCode", (long)closeFrame.statusCode()).addKeyValue("reasonText", closeFrame.reasonText()).log("Received CloseWebSocketFrame");
            this.serverCloseWebSocketFrame = closeFrame.retain();
            if (this.closeCallbackFuture == null) {
                this.loggerReference.get().atVerbose().log("Send CloseWebSocketFrame");
                closeFrame.retain();
                channel.writeAndFlush((Object)closeFrame).addListener(future -> channel.close());
            } else {
                channel.close();
            }
            return true;
        }
        if (webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof ContinuationWebSocketFrame) {
            if (this.compositeByteBuf == null) {
                this.compositeByteBuf = ByteBufAllocator.DEFAULT.compositeBuffer();
            }
            this.compositeByteBuf.addComponent(true, webSocketFrame.content().retain());
            if (!webSocketFrame.isFinalFragment()) {
                return true;
            }
            this.publishBuffer();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishBuffer() {
        ByteBuffer[] nioBuffers = this.compositeByteBuf.nioBuffers();
        if (nioBuffers.length == 0) {
            return;
        }
        try {
            BinaryData data = BinaryData.fromListByteBuffer(Arrays.asList(nioBuffers));
            String collected = data.toString();
            WebPubSubMessage deserialized = this.messageDecoder.decode(collected);
            this.messageHandler.accept(deserialized);
        }
        finally {
            WebSocketClientHandler.release(this.compositeByteBuf);
        }
    }

    void setClientCloseCallbackFuture(CompletableFuture<Void> callbackFuture) {
        this.closeCallbackFuture = callbackFuture;
    }

    public CompletableFuture<Void> getClientCloseCallbackFuture() {
        return this.closeCallbackFuture;
    }

    CloseWebSocketFrame getServerCloseWebSocketFrame() {
        return this.serverCloseWebSocketFrame;
    }

    private static void release(CompositeByteBuf buffer) {
        if (buffer.refCnt() > 0) {
            buffer.release();
            buffer.clear();
        }
    }
}

