/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessageAck;
import java.io.IOException;
import java.util.Objects;

public final class SendEventMessage
extends WebPubSubMessageAck {
    private static final String TYPE = "event";
    private String event;
    private String dataType;
    private Object data;

    public String getType() {
        return TYPE;
    }

    public String getEvent() {
        return this.event;
    }

    public SendEventMessage setEvent(String event) {
        this.event = event;
        return this;
    }

    @Override
    public SendEventMessage setAckId(Long ackId) {
        super.setAckId(ackId);
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public SendEventMessage setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public SendEventMessage setData(Object data) {
        this.data = data;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("type", TYPE).writeNumberField("ackId", (Number)this.getAckId()).writeStringField(TYPE, this.event).writeStringField("dataType", this.dataType).writeStringField("data", Objects.toString(this.data, null)).writeEndObject();
    }

    public static SendEventMessage fromJson(JsonReader jsonReader) throws IOException {
        return (SendEventMessage)jsonReader.readObject(reader -> {
            SendEventMessage sendEventMessage = new SendEventMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ackId".equals(fieldName)) {
                    sendEventMessage.setAckId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if (TYPE.equals(fieldName)) {
                    sendEventMessage.event = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    sendEventMessage.dataType = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    sendEventMessage.data = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return sendEventMessage;
        });
    }
}

