/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.models.TestRunStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class TestRunDetail
implements JsonSerializable<TestRunDetail> {
    private final TestRunStatus status;
    private final String configurationId;
    private final Map<String, String> properties;

    public TestRunStatus getStatus() {
        return this.status;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("configurationId", this.configurationId);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TestRunDetail fromJson(JsonReader jsonReader) throws IOException {
        return (TestRunDetail)jsonReader.readObject(reader -> {
            TestRunStatus status = null;
            String configurationId = null;
            Map properties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = TestRunStatus.fromString(reader.getString());
                    continue;
                }
                if ("configurationId".equals(fieldName)) {
                    configurationId = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new TestRunDetail(status, configurationId, properties);
        });
    }

    private TestRunDetail(TestRunStatus status, String configurationId, Map<String, String> properties) {
        this.status = status;
        this.configurationId = configurationId;
        this.properties = properties;
    }
}

