/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.models.RecommendationCategory;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TestProfileRunRecommendation
implements JsonSerializable<TestProfileRunRecommendation> {
    private final RecommendationCategory category;
    private List<String> configurations;

    private TestProfileRunRecommendation(RecommendationCategory category) {
        this.category = category;
    }

    public RecommendationCategory getCategory() {
        return this.category;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category == null ? null : this.category.toString());
        jsonWriter.writeArrayField("configurations", this.configurations, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TestProfileRunRecommendation fromJson(JsonReader jsonReader) throws IOException {
        return (TestProfileRunRecommendation)jsonReader.readObject(reader -> {
            RecommendationCategory category = null;
            List configurations = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("category".equals(fieldName)) {
                    category = RecommendationCategory.fromString(reader.getString());
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    configurations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            TestProfileRunRecommendation deserializedTestProfileRunRecommendation = new TestProfileRunRecommendation(category);
            deserializedTestProfileRunRecommendation.configurations = configurations;
            return deserializedTestProfileRunRecommendation;
        });
    }
}

